#include "route.h"

int get_mask_len(__u32 mask) 
{
	int i = 32;
	mask = ntohl(mask);
	printf("mask = %ld\n",mask);
	while((mask & 1) == 0) {
		mask = mask >> 1;
		i--;
	}
	printf("mask length = %d\n", i);
	return i;
}

int addattr_l(struct nlmsghdr *n, int maxlen, int type, void *data, int alen)
{
	int len = RTA_LENGTH(alen);
	struct rtattr *rta;

	if (NLMSG_ALIGN(n->nlmsg_len) + len > maxlen)
		return -1;
	rta = (struct rtattr*)(((char*)n) + NLMSG_ALIGN(n->nlmsg_len));
	rta->rta_type = type;
	rta->rta_len = len;
	memcpy(RTA_DATA(rta), data, alen);
	n->nlmsg_len = NLMSG_ALIGN(n->nlmsg_len) + len;
	return 0;
}

/**
* Send a request to NETLINK to add the routing entry
*/
int route_add(int fd, __u32 destination, __u32 gateway, __u32 mask, __u32 ifc_val)
{
 	route_request netlink_req;
	struct sockaddr_nl local;
	struct sockaddr_nl peer;   
	struct iovec iov_info;

	bzero(&local, sizeof(local));
	local.nl_family = AF_NETLINK;
	local.nl_pad = 0;
	local.nl_pid = getpid();
	local.nl_groups = 0;
	if(bind(fd, (struct sockaddr*) &local, sizeof(local)) < 0) {
		perror("Error in sock bind\n");
		exit(1);
	}


	//initialize request
	bzero(&netlink_req, sizeof(netlink_req));

	netlink_req.nlmsg_info.nlmsg_len = NLMSG_LENGTH(sizeof(struct rtmsg));
	netlink_req.nlmsg_info.nlmsg_flags = NLM_F_REQUEST | NLM_F_CREATE;
	netlink_req.nlmsg_info.nlmsg_type = RTM_NEWROUTE;

	netlink_req.rtmsg_info.rtm_family = AF_INET;
	netlink_req.rtmsg_info.rtm_table = RT_TABLE_MAIN;
	netlink_req.rtmsg_info.rtm_dst_len = get_mask_len(mask);

	netlink_req.rtmsg_info.rtm_protocol = RTPROT_STATIC;
	netlink_req.rtmsg_info.rtm_scope = RT_SCOPE_UNIVERSE;
	netlink_req.rtmsg_info.rtm_type = RTN_UNICAST;

	addattr_l(&netlink_req.nlmsg_info, sizeof(netlink_req), RTA_DST, &destination, 4);
	addattr_l(&netlink_req.nlmsg_info, sizeof(netlink_req), RTA_GATEWAY, &gateway, 4);
	addattr_l(&netlink_req.nlmsg_info, sizeof(netlink_req), RTA_OIF, &ifc_val, 4);

	iov_info.iov_base = (void *) &netlink_req.nlmsg_info;
	iov_info.iov_len = netlink_req.nlmsg_info.nlmsg_len;

	bzero(&peer, sizeof(peer));
	peer.nl_family = AF_NETLINK;
	peer.nl_pad = 0;
	peer.nl_pid = 0;
	peer.nl_groups = 0;

	// Forming the message to be sent.
	struct msghdr msg = {
		(void*)&peer, sizeof(peer),
		&iov_info,   1,
		NULL,   0,
		0
	};

	if(sendmsg(fd, &msg, 0) < 0) {
		perror("Error in sendmsg\n");
		exit(1);
	}
}

int route_del(int fd, __u32 destination, __u32 gateway, __u32 mask, __u32 ifc_val)
{
 	route_request netlink_req;
	struct sockaddr_nl local;
	struct sockaddr_nl peer;   
	struct iovec iov_info;

	bzero(&local, sizeof(local));
	local.nl_family = AF_NETLINK;
	local.nl_pad = 0;
	local.nl_pid = getpid();
	local.nl_groups = 0;
	if(bind(fd, (struct sockaddr*) &local, sizeof(local)) < 0) {
		perror("Error in sock bind\n");
		exit(1);
	}


	//initialize request
	bzero(&netlink_req, sizeof(netlink_req));

	netlink_req.nlmsg_info.nlmsg_len = NLMSG_LENGTH(sizeof(struct rtmsg));
	netlink_req.nlmsg_info.nlmsg_flags = NLM_F_REQUEST;
	netlink_req.nlmsg_info.nlmsg_type = RTM_DELROUTE;

	netlink_req.rtmsg_info.rtm_family = AF_INET;
	netlink_req.rtmsg_info.rtm_table = RT_TABLE_MAIN;
	netlink_req.rtmsg_info.rtm_dst_len = get_mask_len(mask);

	addattr_l(&netlink_req.nlmsg_info, sizeof(netlink_req), RTA_DST, &destination, 4);
	addattr_l(&netlink_req.nlmsg_info, sizeof(netlink_req), RTA_GATEWAY, &gateway, 4);
	addattr_l(&netlink_req.nlmsg_info, sizeof(netlink_req), RTA_OIF, &ifc_val, 4);

	iov_info.iov_base = (void *) &netlink_req.nlmsg_info;
	iov_info.iov_len = netlink_req.nlmsg_info.nlmsg_len;

	bzero(&peer, sizeof(peer));
	peer.nl_family = AF_NETLINK;
	peer.nl_pad = 0;
	peer.nl_pid = 0;
	peer.nl_groups = 0;

	// Forming the message to be sent.
	struct msghdr msg = {
		(void*)&peer, sizeof(peer),
		&iov_info,   1,
		NULL,   0,
		0
	};

	if(sendmsg(fd, &msg, 0) < 0) {
		perror("Error in sendmsg\n");
		exit(1);
	}
}
