#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <netdb.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <signal.h>     /* for sigaction() */

#define PORT 3490 // the port client will be connecting to 
#define MAXDATASIZE 100 // max number of bytes we can get at once 
#define RETRY_TIMEOUT 5

static void sig_alrm (int signo) { 
	printf("ALARM WENT OFF\n");
	return; 
}

int main(int argc, char *argv[])
{
	int retry_cnt = 0;
	int sockfd, numbytes;  
	char buffer[MAXDATASIZE];
	struct hostent *he;
	struct sockaddr_in their_addr; // connector's address information 
	socklen_t addr_len;
	struct sigaction myaction;       /* For setting signal handler */

	if (argc != 2) {
		fprintf(stderr,"usage: client hostname\n");
		exit(1);
	}

	if ((he=gethostbyname(argv[1])) == NULL) {  // get the host info 
		perror("gethostbyname");
		exit(1);
	}

	if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
		perror("socket");
		exit(1);
	}

	their_addr.sin_family = AF_INET;    // host byte order 
	their_addr.sin_port = htons(PORT);  // short, network byte order 
	their_addr.sin_addr = *((struct in_addr *)he->h_addr);
	memset(&(their_addr.sin_zero), '\0', 8);  // zero the rest of the struct 

	if (connect(sockfd, (struct sockaddr *)&their_addr, sizeof(struct sockaddr)) == -1) {
		perror("connect");
		exit(1);
	}

	/* set signal handler for alarm signal */
	myaction.sa_handler = sig_alrm;
//	if (sigfillset(&myaction.sa_mask) < 0) /* block everything in handler */
//		perror("sigfillset() failed");
	if (sigemptyset(&myaction.sa_mask) < 0) /* unblock everything in handler */
		perror("sigemptyset() failed");
	myaction.sa_flags = 0;

	if (sigaction(SIGALRM, &myaction, 0) < 0)
		perror("sigaction() failed for sigalrm");


	while(retry_cnt < 3){
		addr_len = sizeof(struct sockaddr);
		alarm(RETRY_TIMEOUT);
		if ((numbytes = recvfrom(sockfd, buffer, 1024 , 0,
						(struct sockaddr *)&their_addr, &addr_len)) < 0) {
			if(errno == EINTR) {
				printf("timeout\n");
				retry_cnt++;
			}
			else 
				exit(1);
		}
	}
}
