#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <netdb.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <signal.h>     /* for sigaction() */
#include <sys/time.h>

#define PORT 3490 // the port client will be connecting to 
#define MAXDATASIZE 100 // max number of bytes we can get at once 
#define RETRY_TIMEOUT 5

int main(int argc, char *argv[])
{
	int retry_cnt = 0;
	int sockfd, numbytes;  
	char buffer[MAXDATASIZE];
	struct hostent *he;
	struct sockaddr_in their_addr; // connector's address information 
	socklen_t addr_len;
	fd_set rset;
	struct timeval tv;

	if (argc != 2) {
		fprintf(stderr,"usage: client hostname\n");
		exit(1);
	}

	if ((he=gethostbyname(argv[1])) == NULL) {  // get the host info 
		perror("gethostbyname");
		exit(1);
	}

	if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
		perror("socket");
		exit(1);
	}

	FD_ZERO(&rset);
	FD_SET(sockfd, &rset);
	tv.tv_sec = 5; //5 second
	tv.tv_usec = 0;


	their_addr.sin_family = AF_INET;    // host byte order 
	their_addr.sin_port = htons(PORT);  // short, network byte order 
	their_addr.sin_addr = *((struct in_addr *)he->h_addr);
	memset(&(their_addr.sin_zero), '\0', 8);  // zero the rest of the struct 


	while((select(sockfd+1, &rset, NULL, NULL, &tv) == 0) && retry_cnt < 3) {
		printf("timeout\n");
		retry_cnt++;
	} 
	if (retry_cnt == 3) {
		printf("exceed retry limit!\n");
		exit(1);
	}
	printf("%d\n", retry_cnt);
	if (FD_ISSET(sockfd, &rset)) {
		if (numbytes = recvfrom(sockfd, buffer, 1024 , 0, (struct sockaddr *)&their_addr, &addr_len) < 0) {
			exit(1);
		}
	}
}
