/* computing induced action of a permutation on the unordered 
   pairs */
#include <stdlib.h>
#define Pos(i,j,n) ((j)-(i)-1+(n)*(i)-(i)*((i)-1)/2)

static void ind_act(const int n, const int g[], int ind[]) {
  int i, ctr;

  for (i = 0, ctr = 0; i < n-1; i++) {
    int j;
    for (j = i+1; j < n; j++) {
      if (g[i] > g[j]) ind[Pos(g[j], g[i], n-1)] = ctr++;
      else             ind[Pos(g[i], g[j], n-1)] = ctr++;
    }
  }
}

int *sym_n_pairs(const int n) {
  int *g, *p, i;
  g = (int*)calloc(n, sizeof(int));
  p = (int*)calloc(n*(n-1), sizeof(int));

  /* action of the transposition */
  for (i = 0; i < n; i++) g[i] = i;
  g[0] = 1;
  g[1] = 0;
  ind_act(n, g, p);

  /* action of the circle */
  for (i = 0; i < n; i++) g[i] = i + 1;
  g[n-1] = 0;
  ind_act(n, g, p + n*(n-1)/2);

  free(g);
  return p;
}
