#include "canon_libcanon.h"

static int n = 0;
static int npairs;
static Matentry **cand;

void init_canon(const int n0) {
  if (n) exit(9); /* should be called once only */
  n = n0;
  npairs = n*(n-1)/2;
  init_perm_canon(n);
  init_minswsets(n);
  cand = (Matentry**)calloc(e2(n-1), sizeof(Matentry*));
}

void canon(const Matentry M, Matentry a[]) {
  int ncand, i;
  Matentry *smallest;
  ncand = minswsets(M, a, cand);
  for (i = 0; i < ncand; i++) perm_canon(cand[i]);
  for (i = 1, smallest = cand[0]; i < ncand; i++) {
    int j; 
    Matentry res;
    for (res = 0, j = 0; j < npairs && !res; j++)
      res = smallest[j] - cand[i][j];
    /* found a copy, if res==0 */
    if (res > 0) smallest = cand[i]; /* current is smaller */
  }
  for (i = 0; i < npairs; i++) a[i] = smallest[i]; 
}
