/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *																			       *
 *						Next Iteration Input Generator							   *
 *																				   *
 *								 Source file									   *
 *																				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "owe_header.h"

static FILE* next_iteration_input_file_ptr;

FILE* next_iteration_input_generator_initialize(void) {

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*  next_iteration_input_generator_initialize
	*  -----------------------------------------
	*
	*	This function creates the next iteration input file and writes into its contents of the
	*	main parameters using the next iteration input file template. The parameters written are:
	*
	*		- Metric polytope		(same as in current input)
	*		- Incidence lower bound	(same as in current input)
	*		- Incidence upper bound (smallest found so far not yet computed)
	*		- Orbit queue size		(same as in current input)
	*
	*	Return value:
	*		- The function returns a pointer to the file so that the set of initial orbits
	*		for the next iteration can be written. Once that is done, the function
	*		next_iteration_input_generator_finalize should be called to close the file.
	*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

	unsigned long int lower_bound; /* This variable will be used to check the value of the lower indicence bound. */

	/* Open (for writing) the next iteration input file. */
	if((next_iteration_input_file_ptr = fopen(next_iteration_input_file_name,"w"))==NULL) {
		owe_error_handler_raise_error("could not create next iteration input file", 0);
		return(0);
	}

	/* If the lower incidence is smaller than the smallest indicence not computed found so far, keep its value. If on the other
	hand, the value of the lower incidence bound is greater than the smallest incidence not computed found so far, set the lower
	incidence value for the next iteration to it. */
	if(owe_setting.incidence_lower_bound<=orbit_databank_get_smallest_incidence_outside_range())
		lower_bound = owe_setting.incidence_lower_bound;
	else
		lower_bound = orbit_databank_get_smallest_incidence_outside_range();

	/* Write into the file the next iteration input template together with the corresponding parameter values. */
	fprintf(next_iteration_input_file_ptr, next_iteration_input_template_text, owe_setting.metric_polytope.n, lower_bound, orbit_databank_get_smallest_incidence_outside_range(), owe_setting.adjacency_lower_bound, owe_setting.adjacency_upper_bound, owe_setting.double_description_time_limit , orbit_databank_get_orbit_queue_size());
	
	/* Return the pointer to the next iteration input file. */
	return(next_iteration_input_file_ptr);
}



void next_iteration_input_generator_finalize(void) {

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*  next_iteration_input_generator_finalize
	*  ---------------------------------------
	*
	*	This function closes the next iteration input file.
	*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

	/* Close the next iteration input file. */
	if(next_iteration_input_file_ptr) fclose(next_iteration_input_file_ptr);
}
