/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *																			       *
 *									Orbit										   *
 *																				   *
 *								 Source file									   *
 *																				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "owe_header.h"

orbit_ptr orbit_create_orbit(coordinate canonical_representative) {

	orbit_ptr orbit;

	/* allocate memory for the orbit. */
	if (!(orbit = (orbit_ptr) malloc(sizeof(orbit_structure)))) owe_error_handler_raise_error("memory allocation error (orbit variable: orbit_create_orbit function: orbit ADT)", 1);
	
	/* allocate memory for the vertex coordinate (with denominator) within the information of the orbit */
	if (!(orbit->canonical_representative = (coordinate) malloc(sizeof(coordinate_item)*(owe_setting.metric_polytope.dimension+1)))) owe_error_handler_raise_error("memory allocation error (coordinate variable : orbit_create_orbit function: orbit ADT)", 1);
	
	/* set the vertex coordinate value of the newly inserted orbit */
	memcpy((orbit->canonical_representative),canonical_representative,sizeof(coordinate_item)*(owe_setting.metric_polytope.dimension+1));

	orbit->skipped = 0;

	return(orbit);

}

void orbit_delete_orbit(orbit_ptr orbit) {
	
	/* Free the canonical representative. */
	free(orbit->canonical_representative);

	/* Free the orbit structure. */
	free(orbit);

}





