/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *																						 *
 *	Orbitwise adjacency tree (binary red-black tree implementation) Abstract Data Type.  *
 *																						 *
 *									Header file											 *
 *																						 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef enum { slave_process_orbit_tree_BLACK, slave_process_orbit_tree_RED } slave_process_orbit_tree_node_color; /* node color */

typedef struct slave_process_orbit_tree_node_structure {
    struct slave_process_orbit_tree_node_structure *left;       /* left child */
    struct slave_process_orbit_tree_node_structure *right;      /* right child */
    struct slave_process_orbit_tree_node_structure *parent;     /* parent */
    slave_process_orbit_tree_node_color color;					/* node color (BLACK, RED) */
	
	coordinate orbit_canonical_representative;
	
} slave_process_orbit_tree_node, *slave_process_orbit_tree_node_ptr;

typedef struct slave_process_orbit_tree_structure {
	slave_process_orbit_tree_node *root;
	unsigned long int size;
} slave_process_orbit_tree, *slave_process_orbit_tree_ptr;


#define slave_process_orbit_tree_compLT(a,b) memcmp(a,b,sizeof(coordinate_item)*(owe_setting.metric_polytope.dimension+1))<0		/* "Less than" coordinate comparator. For basic types this would be: compLT(a,b) (a < b) */

#define slave_process_orbit_tree_compEQ(a,b) memcmp(a,b,sizeof(coordinate_item)*(owe_setting.metric_polytope.dimension+1))==0	/* "Equal" coordinate comparator; for basic types this would be: compEQ(a,b) (a == b) */

#define slave_process_orbit_tree_NIL &slave_process_orbit_tree_sentinel	/* all leafs are sentinels */

/* Function prototypes */
	/* Access functions */
		/* Constructor */
		void slave_process_orbit_tree_initialize(slave_process_orbit_tree_ptr tree);

		/* Destructor */
		void slave_process_orbit_tree_delete(slave_process_orbit_tree_ptr tree);

		/* Insert orbit */
		coordinate slave_process_orbit_tree_insert(slave_process_orbit_tree_ptr tree, coordinate canonical_representative);

		/* Find an orbit */
		coordinate slave_process_orbit_tree_find(slave_process_orbit_tree_ptr tree, coordinate canonical_representative);

	/* Internal functions */
		/* tree rotation (left) function. */
		static void slave_process_orbit_tree_rotateLeft(slave_process_orbit_tree_node_ptr *tree, slave_process_orbit_tree_node *x);

		/* tree rotation (right) function. */
		static void slave_process_orbit_tree_rotateRight(slave_process_orbit_tree_node_ptr *tree, slave_process_orbit_tree_node *x);

		/* Fixup function. */
		static void slave_process_orbit_tree_insertFixup(slave_process_orbit_tree_node_ptr *tree, slave_process_orbit_tree_node *x);

		/* Tree elimination. */
		void slave_process_orbit_tree_delete_tree_structure(slave_process_orbit_tree_ptr tree);


