/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *																			       *
 *							   OWE Error handler								   *
 *																				   *
 *								  Source file									   *
 *																				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include"owe_header.h"

void owe_error_handler_raise_error(char* error_description, unsigned char fatal) {

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*  owe_error_handler_raise_error
	*  -----------------------------
	*  Parameters:
	*		- error description: a string containing a textual description of the error.
	*		- fatal: flag indicating if the error is fatal (value 1) or not (value 0).
	*				 A fatal error is such that on the event of it, it is not worth continuing
	*				 the computation, so program is terminated.
	*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

	/* Print error description on default and error streams. */
	printf("\n%s: %s",(fatal)?"Error":"Warning",error_description);
	fprintf(stderr, "\n%s: %s",(fatal)?"Error":"Warning",error_description);
	if(fatal) { /* If error is fatal, abort program. */
		printf("\nAborting program execution...\n");
		fprintf(stderr, "\nAborting program execution...\n");
		fflush(stdout);
		fflush(stderr);
		MPI_Abort(MPI_COMM_WORLD, 1);
	}
}
