/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *																			       *
 *								OWE Main header file							   *
 *																				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Flags for debug purposes. */
/*#define DEBUG_ORBIT_DATABANK*/
/*#define DEBUG_CDDLIB*/
/*#define DEBUG_ORBIT_NEIGHBORHOOD_CALCULATION*/
/*#define DEBUG_CANON*/
/*#define DEBUG_MPI_MESSAGES_MASTER*/
/*#define DEBUG_MPI_MESSAGES_SLAVE*/

/* MPI definitions. */
	/* Message tags*/
		/* From master to slave process. */
			#define OWE_MPI_TAG_PROCESS_ORBIT 1		/* Used in messages sent from master to slave processes
													indicating the contents of the message is an orbit
													to be computed. */
			#define OWE_MPI_TAG_FINALIZE 2			/* When computation is complete, the master sends this
													message tag to all slave processes indicating no further
													computation will be performed. Slaves will have to finalize,
													closing files and freeing memory. */
		/* From slave to master process. */
			#define OWE_MPI_TAG_NEW_ORBIT_FOUND 3	/* Used in messages sent from slave to master indicating
														the contents of the message is a "potential" new orbit. */
			#define OWE_MPI_TAG_SLAVE_FINISHED_COMPUTING_ORBIT 4 /* Used in messages sent from slave to master indicating
																	the slave has finished computing and is now available
																	to compute other orbits. */
			#define OWE_MPI_TAG_SLAVE_SKIPPED_ORBIT 5 /* Used in messages sent from slave to master indicating that the orbit
																	has not been computed. This is the case when the adjacency
																	of the orbit is outside range. */

/* Standard libraries. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>
#include <math.h>

/* CDDLib libraries. */
#include "cddsetoper.h"						 /* CDDLib setoper */
#include "cdd.h"							 /* CDDLib */

/* Canon libraries. */
#include "canon_libcanon.h"					 /* Main canon lib for initialization and canonical representative calculations. */

/* MPI Library. */
#include "mpi.h"							 /* MPI Library. */

/* OWE specific libraries. */
#include "owe_error_handler.h"				 /* OWE error handling. */
#include "orbit.h"							 /* Orbit header. */
#include "metric_polytope.h"				 /* Metric polytope H-representations. */
#include "incidence_sorted_orbit_priority_queue.h" /* Incidence sorted priority queue (binary heap implementation) abstract data type header. */
#include "orbit_tree.h"						 /* Orbit tree abstract data type header. */
#include "slave_process_orbit_tree.h"		 /* Slave process orbit tree. */
#include "orbitwise_adjacency_tree.h"		 /* Orbitwise adjacency tree abstract data type header. */
#include "orbit_databank.h"					 /* Orbit DataBank abstract data type header. */
#include "owe_lib.h"						 /* OWE general purpose functions. */
#include "orbit_processor.h"				 /* Orbit processor header. */
#include "input_parameter_reader.h"			 /* Input parameter reader. */
#include "owe_master_process.h"				 /* OWE master process. */
#include "owe_slave_process.h"				 /* OWE slave process. */
#include "processor_queue.h"				 /* OWE processor queue. */
#include "next_iteration_input_generator.h"	 /* Next iteration input generator. */
#include "owe.h"							 /* OEW header. */
