
import java.util.*;
import java.lang.*;
import ca.mcmaster.se3m04.*;
import junit.framework.*;

/**
 * Define class for simple test suite for assignment 3
 */
public class test3 extends TestCase {
	private Algebraic x, y, i1, i0, i2, f1, f0, f3p14, foo;
	private Algebraic xpy, ypy, ypx;
	private Algebraic xty, yty, yt1;
	private Algebraic ye2;
	private AList a1, a2, a3, a4, a5, a6, a7, a8, a9;
	private ASet s1, s2, s3, s4, s5, s6, s7, s8, s9;
	private Relation r1, r2, r3, r4;
	private ArrayList al1, al2, al3, al4, al5;
	private Vector v1;

    static public Test suite() {
		return new TestSuite(test3.class);
    }

	protected void setUp() {
		/* create some atomic objects */
		x = new Symbol("x");
		y = new Symbol("y");
		foo = new Symbol("foo");
		i1 = new AnInteger("1");
		i0 = new AnInteger("0");
		i2 = new AnInteger("2");
		f1 = new AFloat("1.0");
		f0 = new AFloat("0.");
		f3p14 = new AFloat("3.14");

		/* create some non-atomic objects */
		/* Sums */
		xpy = new Sum(x, y);
		ypx = new Sum(y, x);
		ypy = new Sum(y, y);
		/* Product */
		xty = new Product(x, y);
		yty = new Product(y, y);
		yt1 = new Product(y, i1);
		/* Power */
		ye2 = new Power(y, i2);
		/* set up to create lists and sets */
		al1 = new ArrayList(3);
		al2 = new ArrayList(6);
		al3 = new ArrayList(1);
		al4 = new ArrayList(0);
		al5 = new ArrayList(2);
		v1 = new Vector(2);
		al1.add(x);
		al1.add(i1);
		al1.add(ypy);
		al2.add(f3p14);
		al2.add(f1);
		al2.add(x);
		al2.add(xpy);
		al2.add(i1);
		al2.add(x);
		/* actually create some lists */
		a1 = new AList(al1);
		al3.add(a1);
		al5.add(yty);
		al5.add(ye2);
		a2 = new AList(al2);
		a3 = new AList(al3);
		a4 = new AList(al4);
		a5 = new AList(al5);
		v1.add(a4);
		v1.add(a5);
		a6 = new AList(v1);
		/* test the convenience methods for lists too
		 * 0, 1, and 2 argument lists can be created directly
		 */
		a7 = new AList();
		a8 = new AList( a1 ); // like a3
		a9 = new AList( yty, ye2 ); // like a5
		/* actually create some sets */
		s1 = new ASet(al1);
		s2 = new ASet(al2);
		al3.clear();
		al3.add(s1); // s3 is the set containing the set s1
		s3 = new ASet(al3);
		s4 = new ASet(al4);
		s5 = new ASet(al5);
		s6 = new ASet(v1);
		/* test the convenience methods for sets too
		 * 0, 1, and 2 argument sets can be created directly
		 */
		s7 = new ASet();
		s8 = new ASet( a1 );
		s9 = new ASet( yty, ye2 );
		/* Equality */
		r1 = new Equality( y, y );
		r2 = new Equality( a5 );
		r3 = new Equality( yty, ye2 );
	}

	public void testSymbol() {
		assertTrue(x instanceof Symbol);
		assertTrue(x instanceof Atomic);
		assertTrue(x instanceof Algebraic);
		assertTrue(x instanceof Expression);
		assertEquals(x.toString(), "x");
		assertTrue(y instanceof Symbol);
		assertTrue(y instanceof Algebraic);
		assertTrue(y instanceof Expression);
		assertEquals(y.toString(), "y");
		assertEquals(foo.toString(), "foo");
	}

	public void testIntegers() {
		assertTrue(i1 instanceof AnInteger);
		assertTrue(i1 instanceof Atomic);
		assertTrue(i1 instanceof Algebraic);
		assertTrue(i1 instanceof Expression);
		assertEquals(i1.toString(), "1");
		assertEquals(i0.toString(), "0");
		assertEquals(i2.toString(), "2");
	}

	public void testFloats() {
		assertTrue(f0 instanceof AFloat);
		assertTrue(f0 instanceof Atomic);
		assertTrue(f0 instanceof Algebraic);
		assertTrue(f0 instanceof Expression);
		assertEquals(f1.toString(), "1.0");
		assertEquals(f0.toString(), "0.0");
		assertEquals(f3p14.toString(), "3.14");
	}

	public void testSum() {
		assertTrue(xpy instanceof Sum);
		assertTrue(xpy instanceof Function);
		assertTrue(xpy instanceof Algebraic);
		assertTrue(xpy instanceof Expression);
		assertTrue(xpy instanceof Nary);
		assertTrue(xpy instanceof Named);
		assertEquals(xpy.toString(), "x+y");
		assertEquals(ypx.toString(), "y+x");
		assertEquals(ypy.toString(), "y+y");
	}

	public void testProduct() {
		assertTrue(xty instanceof Product);
		assertTrue(xty instanceof Function);
		assertTrue(xty instanceof Algebraic);
		assertTrue(xty instanceof Expression);
		assertTrue(xty instanceof Nary);
		assertTrue(xty instanceof Named);
		assertEquals(xty.toString(), "x*y");
		assertEquals(yty.toString(), "y*y");
		assertEquals(yt1.toString(), "y*1");
	}

	public void testPower() {
		assertTrue(ye2 instanceof Power);
		assertTrue(ye2 instanceof Function);
		assertTrue(ye2 instanceof Algebraic);
		assertTrue(ye2 instanceof Expression);
		assertTrue(ye2 instanceof Nary);
		assertTrue(ye2 instanceof Named);
		assertEquals(ye2.toString(), "y^2");
	}

	public void testList() {
		assertTrue(a1 instanceof Agregates);
		assertTrue(a1 instanceof Expression);
		assertTrue(a1 instanceof Nary);
		assertEquals("[]",a4.toString());
		assertEquals("["+a1.toString()+"]",a3.toString());
		assertEquals("[3.14,1.0,x,x+y,1,x]", a2.toString());
		assertEquals("[x,1,y+y]",a1.toString());
		assertEquals("[y*y,y^2]",a5.toString());
		assertEquals("["+a4.toString()+","+a5.toString()+"]",a6.toString());
		assertEquals(a4.toString(), a7.toString());
		assertEquals(a3.toString(), a8.toString());
		assertEquals(a5.toString(), a9.toString());
		assertTrue(a1.getArguments() instanceof ListIterator);
		assertEquals(3, a1.getNumberOfArguments());
		assertEquals(6, a2.getNumberOfArguments());
		assertEquals(1, a3.getNumberOfArguments());
		assertEquals(0, a4.getNumberOfArguments());
		assertEquals(2, a5.getNumberOfArguments());
		assertEquals(2, a6.getNumberOfArguments());
		assertEquals(0, a7.getNumberOfArguments());
		assertEquals(1, a8.getNumberOfArguments());
		assertEquals(2, a9.getNumberOfArguments());
		/* they look the same, but they are different objects */
		assertNotSame(a4, a7);
		assertNotSame(a3, a8);
		assertNotSame(a5, a9);
	}

	public void testSet() {
		assertTrue(s1 instanceof Agregates);
		assertTrue(s1 instanceof Expression);
		assertTrue(s1 instanceof Nary);
		assertTrue(s1.getArguments() instanceof Iterator);
		// all permutations...
		HashSet ss1 = new HashSet(6);
		ss1.add("{x,1,y+y}");
		ss1.add("{1,x,y+y}");
		ss1.add("{x,y+y,1}");
		ss1.add("{1,y+y,x}");
		ss1.add("{y+y,x,1}");
		ss1.add("{y+y,1,x}");
		assertTrue( ss1.contains( s1.toString()) );
		// too many permutations, just check length!
		assertEquals(18, s2.toString().length());
		// check s3 starts with {{, ends with }}.  inner set is s1.
		String ss3 = s3.toString();
		assertTrue( ss3.startsWith( "{{" ) );
		assertTrue( ss3.endsWith( "}}" ) );
		assertTrue( ss1.contains( ss3.substring(1, ss3.length()-1) ) );
		assertEquals("{}",s4.toString());
		// just make cursory checks on the rest
		String ss5 = s5.toString();
		assertTrue( ss5.startsWith( "{" ) );
		assertTrue( ss5.endsWith( "}" ) );
		assertEquals(9, ss5.length());
		String ss6 = s6.toString();
		assertTrue( ss6.startsWith( "{[" ) );
		assertTrue( ss6.endsWith( "}" ) );
		assertEquals( s7.toString().length(), s4.toString().length() );
		assertEquals( s8.toString().length(), s3.toString().length() );
		assertEquals( s9.toString().length(), s5.toString().length() );
		assertTrue(s1.getArguments() instanceof Iterator);
		assertEquals(3, s1.getNumberOfArguments());
		assertEquals(5, s2.getNumberOfArguments()); // 5, not 6 !
		assertEquals(1, s3.getNumberOfArguments());
		assertEquals(0, s4.getNumberOfArguments());
		assertEquals(2, s5.getNumberOfArguments());
		assertEquals(2, s6.getNumberOfArguments());
		assertEquals(0, s7.getNumberOfArguments());
		assertEquals(1, s8.getNumberOfArguments());
		assertEquals(2, s9.getNumberOfArguments());
	}

	public void testEquality() {
		assertTrue(r1 instanceof Equality);
		assertTrue(r1 instanceof Relation);
		assertTrue(r1 instanceof Structured);
		assertTrue(r1 instanceof Expression);
		assertTrue(r1 instanceof Nary);
		assertTrue(r1 instanceof Named);
		assertEquals("y=y", r1.toString());
		assertEquals("(y*y)=(y^2)", r2.toString());
		assertEquals(r2.toString(), r3.toString());
	}

	public void testExpressions() {
		Expression e1 = new Product(ye2,yty);
		assertEquals("(y^2)*(y*y)",e1.toString());
		Expression e2 = new Power(xty,ypy);
		assertEquals("(x*y)^(y+y)",e2.toString());
		Expression e3 = new Power(i0,new AnInteger("-1"));
		assertEquals("0^-1",e3.toString());
		Expression e4 = new Power(foo, foo);
		assertEquals("foo^foo",e4.toString());

		/* And the final test, what we were after
		 * all along, sets of equations ! 
		 */
		Expression e5 = new Equality(y, new Sum(x, foo));
		Expression e6 = new Equality(ye2, new Sum(xty, f3p14));
		Expression fin = new ASet(e5, e6);
		HashSet res = new HashSet(2);
		res.add("{y=(x+foo),(y^2)=((x*y)+3.14)}");
		res.add("{(y^2)=((x*y)+3.14),y=(x+foo)}");
		assertTrue( res.contains( fin.toString() ) );
	}

	public void testErrors() {
		try {
			ArrayList al = new ArrayList( 1 );
			al.add( "foo!" ); // not an Expression!
			AList a = new AList( al );
			System.out.println(a.toString());
			assertTrue(false); // should not get here
		} catch ( IllegalArgumentException iae) {
			assertTrue(true);
		}
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}
}

