package ca.mcmaster.se3m04;

import java.util.*;

public abstract class Expression {
	/**
	 * This prints n-ary infix operators that degenerate to a single
	 * value (degen) in the 0 case, and just the argument in the 1-ary
	 * case.  Like + and * do.
	 */
	String toInfixString(AList al, Symbol name, String degen) {
		int l=al.getNumberOfArguments();
		if (l==0) {
			return degen;
		} else { 
			Iterator getit = al.getArguments();
			Algebraic first = (Algebraic)getit.next();
			String s = Decorate(first);
			if (l>1) {
				String symb=name.toString();
				while( getit.hasNext() ) {
					s = s + symb + Decorate((Algebraic)getit.next());
				}
			}
			return s;
		}
	}

	String Decorate( Algebraic a ) {
		if (a instanceof Atomic) {
			return a.toString();
		} else {
			return "("+a.toString()+")";
		}
	}
}

