package ca.mcmaster.se3m04;

import java.util.*;

public class Power extends Function {
	private AList al;
	private static final Symbol name = new Symbol("^");

	public Power( AList ll ) {
		if (ll.getNumberOfArguments() != 2) {
			throw new IllegalArgumentException("power must have exactly 2 arguments");
		}
		al = ll;
	}

	public Power( Algebraic a1, Algebraic a2) {
		al = new AList( a1, a2 );
	}

	public Symbol getName() {
		return name;
	}

	public Iterator getArguments() {
		return al.getArguments();
	}

	public String toString() {
		return this.toInfixString(al, name, "");
	}
}
