/* producers module */

#include "env.h"
#include "producers.h"
#include "minmax.h"

/* global structure definitions which holds all the random numbers */
typedef struct t_producer {
	int current_prod;
	int quant;
	int rampup;
	int online;
	int offline;
	int buffer;
} t_producer;

static t_producer producers[NPROD];

void init_prod(void){//init the power plants

	producers[0].buffer = 13; //buffering percentage
	producers[0].offline = 158; //min producation before it goes offline
	producers[0].online = 4; //single user constraint
	producers[0].quant = 5058; //max possible production
	producers[0].rampup = 23; //percentage increase
	producers[0].current_prod = 0; //indicate what the current max production is
	
	producers[1].buffer = 24;
	producers[1].offline = 254;
	producers[1].online = 10;
	producers[1].quant = 5058;
	producers[1].rampup = 19;
	producers[1].current_prod = 0; //indicate what the current max production is

	producers[2].buffer = 19;
	producers[2].offline = 144;
	producers[2].online = 2;
	producers[2].quant = 5044;
	producers[2].rampup = 9;
	producers[2].current_prod = 0; //indicate what the current max production is

	producers[3].buffer = 11;
	producers[3].offline = 161;
	producers[3].online = 2;
	producers[3].quant = 2561;
	producers[3].rampup = 6;
	producers[3].current_prod = 0; //indicate what the current max production is

	producers[4].buffer = 13;
	producers[4].offline = 143;
	producers[4].online = 10;
	producers[4].quant = 3543;
	producers[4].rampup = 8;
	producers[4].current_prod = 0; //indicate what the current max production is
}

void update_power_plants(int *cps) {
	int i, cp;
	t_producer *p;
	for(i=0; i < NPROD; i++){
		p = &(producers[i]);
		p->current_prod += p->rampup;
		p->current_prod = min(p->current_prod, p->quant);
		/* account for buffering here */
		/* p->current_prod = depends on demand */

		/* cp = (p.current_prod * (1.0- (double)p.buffer/100.0));  */
		cp = p->current_prod;
		/* printf("p%d - cp=%d offline=%d\n", i, cp, p->offline); */
		cps[i]= (cp < p->offline ? 0 : cp);
	}
}
