                        
class room:
    
    
    def __init__(self,name):
        
        
        # Door status and lock status are used to denote opening of the door and whether the door is locked.
        # Open door will take the player as input, check the lock status...if the door is locked it will try
        # to find the appropriate key on the player, if there is no key they player cannot enter
        self.lock_status = False
        self.door_status = True
        self.lock_key = None

        # func is a function that is defined in pyVenture and assigned by setFunction(f)
        # it will be executed each iteration of the game loop, if inside this room
        self.func = None

        self.question="" # Changed this to a string
        self.answer_list = [] # Multiple choice answers will be stored here, the index of the correct answer is stored at the end of this
        self.name = name
        self.items = []
        self.adjacent_rooms = []
        self.description = ""
    
    def setFunction(self,f):
        self.func = f
    
    def getName(self):
        
        return self.name
    
    def checkKey(self,items):
        
        if self.lock_key is None:

            return False

        for item in items:
            if item == self.lock_key:
                return True
        
        return False
        
    def setLockStatus(self,locked,key = None):

            if locked:
                self.lock_status = True
            else:
                self.lock_status = False
            
           
            self.lock_key = key

    def getLockStatus(self):

        return lock_status

    def isQuestion(self):
    
        if (self.question == ""):
            return False
        else:
            return True
    
    def getQuestion(self):
        
        return self.question
    
    def getAnswers(self):
        
        return self.answer_list
    

    def setQuestion(self,question_array):
    
        # Assume question is at question_array[0] and answer
        # is at len(question_array)-1
        
        self.question = question_array[0] #Extract question
        self.answer_list = question_array[1:] # take the rest of the list for the answers
        

    def isAnswer(self,answer_index):
        
        return answer_index == self.answer_list[len(self.answer_list)-1] #Check if the index matches
    

    def getAdjacentRooms(self):
        
        return self.adjacent_rooms


    def getItems(self):

        return self.items


    def addItems(self, Items):

        '''
        addItems:
        
                This function will be called internally to add a single item
                or a list of items to a room.
        
        '''

        if (type(Items) is str):
            self.items.append(Items)
            self.items = list(set(self.items)) # Remove duplicates
        else:
            self.items += Items
            self.items = list(set(self.items)) # Remove duplicates


    def removeItems(self, Items):
        
        '''
        removeItems:
    
            This function is used to remove a single item or a list of items
            from a room. This function is called internally to ensure a player
            cant pickup the same items multiple times.
        '''
        
        if (type(Items) is str):
            if Items in self.items:
                self.items.remove(Items)
        else:
            for aItem in Items:
                if aItem in self.items:
                    self.items.remove(aItem)
    
    def removeAllItems(self):

        self.items = []
    
    
    def setDescription(self, desc):
        
        '''
        setDescription:
        
                This takes in a string which will be read to the user when
                they enter the room
        
        '''
        
        
        self.description = desc
        
        
        
    def getDescription(self):
        
        '''
        getDescription:
        
                Used internally to print the rooms description when the user
                walks into the room.
        
        '''
        
        return self.description
            
            
    def addAdjacentRoom(self,rooms,distance = None):
        
        '''
        addAdjacentRoom:
        
            Used to connect the current room to other rooms.
            Takes a list of room and adds them to adjacent_rooms
            with distance 1 if not specified
    
        '''

        if distance is None:
            for room in rooms:

                duplicate = False
                for adj in self.adjacent_rooms:
                    if(adj[0] == room):
                        duplicate = True
                        break
        
                if (duplicate == False):

                    self.adjacent_rooms.append([room,1])
                    room.adjacent_rooms.append([self,1])

        #else:
            #TODO incorporate distance
        
    def removeAdjacentRoom(self,room):
        '''
        removeAdjacentRoom:
        
            Removes a room adjacent from self from each rooms
            adjacent_rooms list
        '''
        # Remove room from this rooms adjacent rooms
        for aRoom in self.adjacent_rooms:
            if room in aRoom:
                self.adjacent_rooms.remove(aRoom)

        # Remove this room from room
        for aRoom in room.adjacent_rooms:
            if self in aRoom:
                room.adjacent_rooms.remove(aRoom)
   
            
           
