import math
import os
from random import randint

class building:
    
    def __init__(self,player):

           
        self.rooms = []
        self.player = player #put the player in the building
        
    
    def getRooms(self):
        
        return self.rooms
    
    
    def addRoom(self,room):
        
                
        '''
        addRoom:
        
                This funciton adds an object of type room to the
                building.
        
        '''
        
        self.rooms.append(room)

    def printRoomPreamble(self,room):
        
        ''' 
        printRoomPreamble:

            Print Preamble each time you enter a new room, example
            You're in the kitchen

            Options for: Kitchen

            0:Bathroom
            1:Dining Room
            Or type quit to exit game
        '''

        print room.getDescription() + "\n"
        print "Options for: " + room.getName() + "\n"

        i = 0
        for aRoom in room.getAdjacentRooms():
            print str(i) + ":" + aRoom[0].getName()
            i = i+1

        print "Or type quit to exit game\n"
    
    def getSelection(self,num):
        
        '''
        getSelection:
            Get raw input from user, insist it is valid
            i.e smaller than num
        '''
        inp = 0
        while True:
            inp = raw_input("Enter your selection: ")
            if inp.strip() == "quit":
                return inp.strip()
            try:
                inp = int(inp.strip())
            except:
                print "Invalid input\n"
                continue
            
            if inp < num:
                break
            else:
                print "Invalid input\n"

        return inp
                
    def answerQuestion(self,room):
        
        '''
        answerQuestion:
            print rooms question and possible answers and get answer from user, returns either True for
            correct or False for incorrect
        '''
        
        print "You must answer a question to gain entrance to this room!\n"
        
        # print question
        print room.getQuestion() + "\n"
        
        # print answers with index for selection
        i = 0
        for answer in room.getAnswers():
            if i == len(room.getAnswers())-1:
                break

            print str(i) + ": " + answer
            i = i + 1
        
        inp = self.getSelection(len(room.getAnswers()))
        
        # interpret quit as incorrect answer, otherwise inp is an index for getAnswers()
        if inp == "quit":
            return False
        else:
            if room.isAnswer(inp):
                return True
            else:
                return False

        

    def playGame(self):
        
        self.player.setCurrentRoom(self.rooms[0])

        # Main game loop, exit on inp == quit
        while True:
            
            # Execute room function, if it has been defined
            if not (self.player.getCurrentRoom().func is None):
                self.player.getCurrentRoom().func()

            # Pick up any items in current room and then remove them
            self.player.pickUp(self.player.getCurrentRoom().items)
            self.player.getCurrentRoom().removeAllItems()

            # Print room info and get user input
            self.printRoomPreamble(self.player.getCurrentRoom())
            inp = self.getSelection(len(self.player.getCurrentRoom().getAdjacentRooms()))
            
            # inp is either "quit" or a valid selection
            if inp == "quit":
                break
            else:
                # get selected room, switch if no question, or answer question and switch iff correct
                nxtRoom = self.player.getCurrentRoom().getAdjacentRooms()[inp][0]
                
                if not nxtRoom.isQuestion():
                    self.player.changeRoom(nxtRoom) # Change Rooms if no question
                else:
                    correct = self.answerQuestion(nxtRoom)
                    if correct:
                        print "\nCorrect\n"
                        self.player.changeRoom(nxtRoom) # Change Rooms if correctly answered
                    else:
                        print "\nIncorrect\n" # Don't change rooms, just loop
                        print "\n\n\n\n\n"
