
            
class player:
    
    def __init__(self, name = None):
        
        self.name  = name
        self.items = []
        self.current_room = None
        self.past_rooms = []
        self.energy = 0



    def changeRoom(self, room):
        '''
        changeRoom:
    
            This function takes in an object of type room and moves the player to that room.
            
            for example, if your player was called Chris, and the room you want to move to
            is called dungeon, you would use chanegRoom like so: Chris.changeRoom(dungeon)
            
            if the room has a lock, check if the player has an item thats a key for the room,
            if not don't switch rooms and print Access denied
        '''

        if room.lock_status:

            if room.checkKey(self.items):

                self.past_rooms.append(self.current_room)
                self.current_room = room
                room.lock_status = False
                print "\n\n\n\n\n"

            else:
                if room.lock_key is None:

                    print "Access Denied\n"

                else:

                    print "Access Denied. You need a " + room.lock_key + " to enter this room\n"

        else:

            self.past_rooms.append(self.current_room)
            self.current_room = room
            print "\n\n\n\n\n"

        
    def pickUp(self, Items):
        
        '''
        pickUp:
    
            This function will add an item in a room to your inventory, currently the game is setup
            so that your player automatically picks up all items in a room. Therefor at this time you
            do not need to call this function directly.
    
        '''

        if(type(Items) is str):
            
            
            self.items.append(Items)
            self.items = list(set(self.items))
            print "You picked up a " + Items

        else:
           
            self.items += Items
            self.items = list(set(self.items))
            
            for item in Items:
                print "You picked up a " + item + "\n\n"

                
    def setEnergy(self, enrgy):
        '''
        setEnergy:
        
                This fuction is used by the system in the beginning to set your energy to its initial value.
                your energy will be the minimum ammount required to traverse all rooms in your building.
        
        '''
        self.energy = enrgy
        


    def getEnergy(self):
        '''
        getEnergy:
        
                This function is used to return the current amount of energy your player has at any
                given time. You should not need to call this function explicitly.
        
        '''
            
        return self.energy
    


    def addEnergy(self,x):
     
        '''
       addEnergy:
       
               This function is to be used by the programmer (you) to make the game unique to your
               story. For example; when you enter a room, you could have the following message play
               
               You entered the kitchen and found an energy drink on the table, it gave you 5 energy.
               
               At this point you would call the addEnergy function and use it to add 5 energy to the
               player like this:
               
               Chris.addEnergy(5)
       
        '''   
        self.energy+=x
        

        
    def removeEnergy(self,x):
        '''
       removeEnergy:
       
               This function is to be used by the programmer (you) to make the game unique to your
               story. For example; when you enter a room, you could have the following message play
               
               You entered the dungeon which contained a large cave troll, you battled the Troll,
               defeating him. However, you lost 5 energy in the process.
               
               At this point you would call the addEnergy function and use it to remove 5 energy from
               the player like this:
               
               Chris.removeEnergy(5)
       
       '''   
        self.energy-=x
        


    def setCurrentRoom(self, room):
        '''
        setCurrentRoom:
                
                This function is used by the system to set the players current room.
                When you move from room to room this function will be called to update
                the appropriate lists.
        
        '''
   
        self.current_room = room
        self.past_rooms.append(room)



    def getCurrentRoom(self):
    
        '''
        getCurrentRoom:
        
                This function is called to return the room object the current player is in
                for example, if you wanted to get the name of the room the player is in you
                would have to call it like so.
                
                Chris.getCurrentRoom().getName() -> not tested yet update later
        '''
            
        return self.current_room
  
