//
//  ProvinceViewController.m
//  NewDemo
//
//  Created by Christopher Feher on 2013-10-08.
//  Copyright (c) 2013 Demo. All rights reserved.
//

#import "ProvinceViewController.h"
#import "ProvinceInfoViewController.h"

@interface ProvinceViewController ()

@end

@implementation ProvinceViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
        self.dataModel = [[ProvinceData alloc] init];
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - UITableViewDataSouce and Delegate
- (NSIndexPath *)tableView:(UITableView *)tableView willSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    
    return indexPath;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    
    ProvinceInfoViewController *pivc = [[ProvinceInfoViewController alloc] init];
    
    NSArray *names = [[self.dataModel provinces] allKeys];
    NSString *currentName = [names objectAtIndex:indexPath.row];
    
    pivc.provinceName = currentName;
    
    [self presentViewController:pivc animated:YES completion:nil];
    
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
}
- (BOOL)tableView:(UITableView *)tableView shouldHighlightRowAtIndexPath:(NSIndexPath *)indexPath{
    
    return YES;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    
    static NSString *identifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:identifier];
    
    if(!cell){
        
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:identifier];

    }
    /*
     Get the list of province names using [[self.dataModel provinces] allKeys]
     get the current name using indexPath.row: [names objectAtIndex:indexPath.row]
     
     get the population by checking the key (name) against the dictionary: [[self.dataModel provinces] objectForKey:currentName]
     */
    NSArray *names = [[self.dataModel provinces] allKeys];
    NSString *currentName = [names objectAtIndex:indexPath.row];
    NSString *pop = [[self.dataModel provinces] objectForKey:currentName];
    
    
    //Set the text labels on the cell
    [cell.textLabel setText:currentName];
    [cell.detailTextLabel setText:pop];
    
    return cell;
    
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    
    /*
     
     NSMutableDictionary *temp = [self.dataModel provinces];
     
     NSInteger myInt = [temp count];
     
     return myInt;
     
     */
    
    return [[self.dataModel provinces] count];
    
}

@end
