\ignore{
\begin{code}
{-# LANGUAGE EmptyDataDecls, MultiParamTypeClasses, FunctionalDependencies, FlexibleInstances, RankNTypes, TemplateHaskell #-}
module UnitDefinitions where

import TypeGen
\end{code}
}

\section{Examples}\label{sec:Examples}

In this module we define a type-level number for the power of units.
The units include six of the SI base units: meter, second, kilogram, Ampere, mole, and Kelvin. 


Class which indicates valid unit additions. 
\begin{code}
class AddUnit a b c | a b -> c, a c -> b, b c -> a where 
\end{code}

Classes of unit types (one class for each SI base unit being used) which include the unit type and exponent, and a function which gives the numerical value of the exponent of the unit.
\begin{code}
class UnitM a where
  toIntM :: a -> Int

class UnitS a where
  toIntS :: a -> Int

class UnitKg a where
  toIntKg :: a -> Int

class UnitA a where
  toIntA :: a -> Int

class UnitMol a where
  toIntMol :: a -> Int
  
class UnitK a where
  toIntK :: a -> Int
\end{code}


For all of the Template Haskell splices below, the definition can be found in \hask{TypeGen}.


Data constuctors for each unit and its exponent. The format of naming datatypes is the accepted unit symbol followed by the exponent, replacing negative signs with underscores.
\begin{code}
$mkUnitDataDecs
\end{code}

Instances of unit classes.
\begin{code}
$mkUnitClasses  
\end{code}

Instances of AddUnit which define all allowed additions of units.
\begin{code}
$mkUnitAddClasses
\end{code}
