import System.Process 
import System.Directory
import Text.Printf
import System.Exit
import System.FilePath.Posix 
import Control.Applicative 
import Control.Monad 

main :: IO ()
main = do
  files <- getLhsFiles 
  let files' = map (\x -> "tex/" ++ takeBaseName x ++ ".tex") files
  zipWithM_ copyFile files files' 
  compileTex "tex/TypeComputation.tex"

find :: FilePath -> IO [FilePath]
find fp = do 
  dirs  <- filter (not . (`elem` ["..", "."])) <$> getDirectoryContents fp

  dirs' <- filterM (doesDirectoryExist . fp') dirs 
  files <- filter ((== ".lhs") . takeExtension) <$> filterM (doesFileExist . fp') dirs 
  
  r <- mapM (find . fp') dirs' 

  return $ map fp' files ++ concat r 
    where fp' = ((fp ++ "/") ++)

getLhsFiles :: IO [FilePath]
getLhsFiles = find "."
                   
cmd :: String -> IO ()
cmd x = do 
  (_,_,_,h) <- createProcess (shell x) 
  ex <- waitForProcess h
  case ex of 
    ExitSuccess      -> return ()
    ExitFailure code -> error $ printf "Processes failed with code %d" code 

compileTex :: FilePath -> IO ()
compileTex fp = do 
  b <- doesFileExist fp
  if b then do
   cmd $ "pdflatex -output-directory=tex " ++ fp 
   cmd $ "pdflatex -output-directory=tex " ++ fp 
  else putStrLn $ fp ++ ": File does not exist"
