#include "StoryDSL.hpp"

#include <iostream>
#include <limits>
#include <stdlib.h>
#include <string>
#include <vector>

using namespace std;

void PressEnterToContinue()
{
    fflush(stdin);
    cin.ignore(numeric_limits<streamsize> ::max(),'\n');
}

int main()
{
    StoryDSL::StoryManager* manager = new StoryDSL::StoryManager();
    vector<bool> eventData(manager->GetStory()->GetNumEvents(), false);

    cout << "Press <Enter> to begin a text-based playthrough of \"" << manager->GetStory()->GetStoryLabel() << "\"" << endl << endl;
    PressEnterToContinue();

    while (manager->GetStory()->GetStoryState()->GetNodeOutTrans().size() > 0)
    {
        vector<StoryDSL::NodeTransition*> trans = manager->GetStory()->GetStoryState()->GetNodeOutTrans();
        vector<string> events;
        vector<string> tempEvents;
        unsigned int i, j;
        string choice;
        unsigned int index = 0;

        // Create vector of all available events
        for (i = 0; i < trans.size(); i++)
        {
            tempEvents = trans[i]->GetNodeTransEvents();
            for (j = 0; j < tempEvents.size(); j++)
                events.push_back(tempEvents[j]);
        }

        do
        {
            cout << "Current story state: " <<  manager->GetStory()->GetStoryState()->GetNodeLabel() << endl;
            cout << "Enter an event number and press enter, or type \"exit\" to exit." << endl << endl;
            for (i = 0; i < events.size(); i++)
                cout << i+1 << ". " << events[i] << endl;
            cout << i+1 << ". Insignificant story event" << endl;

            cin >> choice;
            cout << endl;

            if (choice == "exit")
                break;

            index = atoi(choice.c_str());
            if (index < 1 || index > i+1)
                cout << "Incorrect entry. Entry must be between 1 and " << i+1 << "." << endl;
        }
        while (index < 1 || index > i+1);

        if (choice == "exit")
            break;
        else if (index != i+1)
        {
            eventData[manager->FindIndex(events[index-1])] = true;
            manager->ReceiveStorySnapshot(eventData);
        }
    }

    cout << "Current story state: " <<  manager->GetStory()->GetStoryState()->GetNodeLabel() << endl << endl;
    cout << "Playthrough is now complete. Press <Enter> to exit." << endl;
    PressEnterToContinue();

    return 0;
}

