﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

class DummyGame
{
    private static void PressEnterToContinue()
    {
        Console.In.ReadLine();
    }

    public static void Main(string[] args)
    {
        StoryDSL.StoryManager manager = new StoryDSL.StoryManager();
        List<Boolean> eventData = new List<Boolean>(manager.GetStory().GetNumEvents());
        for (int i = 0; i < eventData.Capacity; i++)
            eventData.Insert(i, false);

        Console.Out.WriteLine("Press <Enter> to begin a text-based playthrough of \"" + manager.GetStory().GetStoryLabel() + "\"\n");
        
        PressEnterToContinue();

        while (manager.GetStory().GetStoryState().GetNodeOutTrans().Count > 0)
        {
            List<String> events = new List<String>(0);
            List<String> tempEvents;
            int i, j;
            String choice;
            int index = 0;

            // Create List of all available events
            for (i = 0; i < manager.GetStory().GetStoryState().GetNodeOutTrans().Count; i++)
            {
                tempEvents = manager.GetStory().GetStoryState().GetNodeOutTrans()[i].GetNodeTransEvents();
                for (j = 0; j < tempEvents.Count; j++)
                    events.Add(tempEvents[j]);
            }

            do
            {
                Console.Out.WriteLine("Current story state: " + manager.GetStory().GetStoryState().GetNodeLabel());
                Console.Out.WriteLine("Enter an event number and press enter, or type \"exit\" to exit.");
                for (i = 0; i < events.Count; i++)
                    Console.Out.WriteLine((i+1) + ". " + events[i]);
                Console.Out.WriteLine((i+1) + ". Insignificant story event");

                choice = Console.In.ReadLine();
                Console.Out.WriteLine("");

                if (choice.Equals("exit"))
                    break;

                if (choice.CompareTo("1") < 0 || choice.CompareTo(Convert.ToString(i + 1)) > 0)
                    Console.Out.WriteLine("Incorrect entry. Entry must be between 1 and " + (i+1) + ".");
                else
                    index = Convert.ToInt32(choice);
            }
            while (index < 1 || index > i);

            if (choice.Equals("exit"))
                break;
            
            eventData[manager.FindIndex(events[index-1])] = true;
            manager.ReceiveStorySnapshot(eventData);
        }

        Console.Out.WriteLine("Current story state: " + manager.GetStory().GetStoryState().GetNodeLabel());
        Console.Out.WriteLine("Playthrough is now complete. Press <Enter> to exit.");
        PressEnterToContinue();
    }
}
