import java.util.Scanner;
import java.util.Vector;


public class DummyGame
{
    private static void PressEnterToContinue()
    {
        Scanner console = new Scanner(System.in);
        console.nextLine();
    }

    public static void main(String[] args)
    {
        StoryDSL.StoryManager manager = new StoryDSL.StoryManager();
        Vector<Boolean> eventData = new Vector<Boolean>(manager.GetStory().GetNumEvents());
        for (int i = 0; i < eventData.capacity(); i++)
            eventData.add(i,false);

        System.out.println("Press <Enter> to begin a text-based playthrough of \"" + manager.GetStory().GetStoryLabel() + "\"\n");
        
        PressEnterToContinue();

        while (manager.GetStory().GetStoryState().GetNodeOutTrans().size() > 0)
        {
            Vector<String> events = new Vector<String>(0);
            Vector<String> tempEvents;
            int i, j;
            String choice;
            int index = 0;

            // Create Vector of all available events
            for (i = 0; i < manager.GetStory().GetStoryState().GetNodeOutTrans().size(); i++)
            {
                tempEvents = manager.GetStory().GetStoryState().GetNodeOutTrans().get(i).GetNodeTransEvents();
                for (j = 0; j < tempEvents.size(); j++)
                    events.add(tempEvents.get(j));
            }

            do
            {
                System.out.println("Current story state: " + manager.GetStory().GetStoryState().GetNodeLabel());
                System.out.println("Enter an event number and press enter, or type \"exit\" to exit.");
                for (i = 0; i < events.size(); i++)
                    System.out.println((i+1) + ". " + events.get(i));
                System.out.println((i+1) + ". Insignificant story event");

                Scanner in = new Scanner(System.in);
                choice = in.nextLine();
                System.out.println("");

                if (choice.contentEquals("exit"))
                    break;

                if (choice.compareTo("1") < 0 || choice.compareTo(Integer.toString(i+1)) > 0)
                    System.out.println("Incorrect entry. Entry must be between 1 and " + (i+1) + ".");
                else
                    index = Integer.parseInt(choice);
            }
            while (index < 1 || index > i);
            
            if (choice.contentEquals("exit"))
                break;
            
            eventData.set(manager.FindIndex(events.get(index-1)),true);
            manager.ReceiveStorySnapshot(eventData);
        }

        System.out.println("Current story state: " + manager.GetStory().GetStoryState().GetNodeLabel());
        System.out.println("Playthrough is now complete. Press <Enter> to exit.");
        PressEnterToContinue();
    }
};
