package ca.mcmaster.se3m04;

import java.io.*;
import java.util.*;

public class Circuit {
	private ArrayList components = new ArrayList(); // set of components

	/**
	 * Constructor.
	 * @param in spice file reader (must implement Iterator)
	 */
	public Circuit( SpiceFileReader in ) {
		boolean firstLine = true;
		while (in.hasNext()) {
			String st = (String)in.next();
			if (!firstLine) {
				parseAndCreateComponent( st );
			} else {
				firstLine = false;
			}
		}
	}

	/**
	 * Print each component in the circuit
	 */
	public void print() {
		Iterator it = components.iterator();
		while (it.hasNext()) {
			((CircuitComponent)it.next()).print();
		}
	}

	/**
	 * After tokenizing the string, dispatch to the proper component
	 * constructor to finish the work
	 * @param s line from a Spice file
	 */
	private void parseAndCreateComponent(String s) {
		// Put all tokens into a Vector for easier traversal
		StringTokenizer st = new StringTokenizer(s);
		Vector v = new Vector();
		while (st.hasMoreElements()) {
			v.addElement(st.nextToken());
		}
		
		if (v.size() >= 3) { // all valid elements have at least 3 items
			String s1 = (String)v.get(0);
			// pull apart known stuff
			char c = s1.charAt(0); // guaranteed to exist
			String nodeName = s1.substring(1);
			String node1 = (String)v.get(1);
			String node2 = (String)v.get(2);
			// dispatch on first letter
				switch (c) {
					case 'C': 
						CircuitComponent comp = new Capacitor(nodeName, node1, node2, v);
						conditionalAdd(comp);
						break;
					case 'I': /* to do */ break;
					case 'L': /* to do */ break;
					case 'R': /* to do */ break;
					case 'V': /* to do */ break;
					default: break;  // simply skip it
				}
		}
	}

	/**
	 * Routine that only adds the current component to the circuit
	 * if and only if it is a valid component.  The component constructor
	 * decides this itself and will name the component "invalid" if so.
	 * @param cc potential circuit component to add
	 */
	private void conditionalAdd(CircuitComponent cc) {
		if (!cc.name.equals("invalid")) {
			components.add(cc);
		}
	}
}
