package ca.mcmaster.se3m04;

import java.io.*;
import java.util.*;

public class CircuitComponent {
	String name; // Name of the component
	String fromNode; // Name of "from" node
	String toNode; // Name of "to" node

	/**
	 * Constructor.
	 * @param n name of the component
	 * @param fn name of the from node
	 * @param tn name of the to node
	 */
	public CircuitComponent(String n, String fn, String tn) {
		name = n;
		fromNode = fn;
		toNode = tn;
	}

	/**
	 * Generic printing function valid for all components
	 * In practice, this should always be overridden by subclasses
	 */
	public void print() {
		System.out.println("Generic component "+name+" between nodes "+
				fromNode+" and "+toNode );
	}

	public String getName() {
		return name;
	}
}
