package ca.mcmaster.se3m04;

import java.io.*;
import java.util.*;

/**
 * Spice file reader.  Builds an object that returns lines
 * from a Spice file one at a time using an Enumeration.
 *
 * @see Iterator
 */
public class SpiceFileReader implements Iterator {
	private Iterator it; // Holds actual lines

	/**
	 * Constructor.
	 * @param filename name of input file
	 */
    public SpiceFileReader( String filename ) {
		ArrayList v = new ArrayList();
		try {
            BufferedReader in;
            in = new BufferedReader( new FileReader( filename ) );

            String st = in.readLine();
            while (st != null) {
                v.add(st);
                st = in.readLine();
            }
        } catch (FileNotFoundException fnfe) {
			System.err.println(fnfe);
        } catch (IOException ioe) {
			System.err.println(ioe);
        }
		// May be empty if file does not exist
		it = v.iterator();
	}

	/**
	 * Expose hasMoreElements from private Iterator it
	 */
    public boolean hasNext() {
        return it.hasNext();
    }

	/**
	 * Expose nextElements from private Iterator it
	 */
    public Object next() {
        return it.next();
    }

	/**
	 * Expose remove from private Iterator it
	 */
    public void remove() {
        it.remove();
    }
}

