package ca.mcmaster.se3m04;

import java.util.*;
import java.lang.*;

public class AList extends Agregates {
	private ArrayList al;

	public AList( List l ) {
		al = new ArrayList(l.size());
		/* must go and verify type dynamically :-( */
		ListIterator i = l.listIterator();
		while (i.hasNext()) {
			Object o = i.next();
			if (!(o instanceof Expression)) {
				throw new IllegalArgumentException();
			} else {
				al.add(o);
			}
		}
	}

	public AList( ) {
		al = new ArrayList();
	}

	public AList( Expression e ) {
		al = new ArrayList(1);
		al.add(e);
	}

	public AList( Expression e1, Expression e2 ) {
		al = new ArrayList(2);
		al.add(e1);
		al.add(e2);
	}

	public int getNumberOfArguments() {
		return al.size();
	}

	public Iterator getArguments() {
		return al.listIterator();
	}

	public String toString() {
		int l=al.size();
		String s="[";
		if (l==0) {
		} else if (l==1) {
			s = s + al.listIterator().next().toString();
		} else { // l>=2
			ListIterator getit = al.listIterator();
			s = s + getit.next().toString();
			while( getit.hasNext() ) {
				s = s + "," + getit.next().toString();
			}
		}
		return s+"]";
	}
}
