/* simulator module */

#include <stdio.h>
#include <stdlib.h>
#include "env.h"
#include "producers.h"
#include "consumers.h"
#include "simulate.h"

/* Function Prototypes */
void init_prod(void); 
void consumption(int);
void power_assignment(int);

/* amount of power that was consumed from the power plant */
static int *prod_storage; 
/* amount of power a plant can produce after buffering */
static int *current_prod_storage; 
/* amount of power each consumer wants at any give time */
static int *consumption_wanted; 
/* amount of power give to the consumer at any given time */
static int *consumption_satisfied;

static int *assignment;

void run_model(int end_time) {
	int i;
	for (i=0; i<end_time; i++) {
		update_power_plants(current_prod_storage);
		consumption(i);
		power_assignment(i);
	}
}

void init_cons() {
	int i;

	init_extra1();
	init_extra2();
	init_extra3();
	init_extra4();
	init_extra5();
	init_extra6();
	init_extra7();
	init_extra8();
	init_extra9();
	init_extra10();
	init_extra11();
	init_extra12();
	init_extra13();
	init_extra14();
	init_extra15();

	for(i=0; i<NCONS*SIM_TIME; i++) { 
		consumption_wanted[i] = 0;
		consumption_satisfied[i] = 0;
	}
}

void consumption(int t) {
	void *tmp;
	
	tmp = (void *)get_struct1();
	consumption_wanted[0*SIM_TIME + t]= consumer1(t, tmp, modif1);
	tmp = (void *)get_struct2();
	consumption_wanted[1*SIM_TIME + t]= consumer2(t, tmp, modif2);
	tmp = (void *)get_struct3();
	consumption_wanted[2*SIM_TIME + t]= consumer3(t, tmp, modif3);
	tmp = (void *)get_struct4();
	consumption_wanted[3*SIM_TIME + t]= consumer4(t, tmp, modif4);
	tmp = (void *)get_struct5();
	consumption_wanted[4*SIM_TIME + t]= consumer5(t, tmp, modif5);
	tmp = (void *)get_struct6();
	consumption_wanted[5*SIM_TIME + t]= consumer6(t, tmp, modif6);
	tmp = (void *)get_struct7();
	consumption_wanted[6*SIM_TIME + t]= consumer7(t, tmp, modif7);
	tmp = (void *)get_struct8();
	consumption_wanted[7*SIM_TIME + t]= consumer8(t, tmp, modif8);
	tmp = (void *)get_struct9();
	consumption_wanted[8*SIM_TIME + t]= consumer9(t, tmp, modif9);
	tmp = (void *)get_struct10();
	consumption_wanted[9*SIM_TIME + t]= consumer10(t, tmp, modif10);
	tmp = (void *)get_struct11();
	consumption_wanted[10*SIM_TIME + t]= consumer11(t, tmp, modif11);
	tmp = (void *)get_struct12();
	consumption_wanted[11*SIM_TIME + t]= consumer12(t, tmp, modif12);
	tmp = (void *)get_struct13();
	consumption_wanted[12*SIM_TIME + t]= consumer13(t, tmp, modif13);
	tmp = (void *)get_struct14();
	consumption_wanted[13*SIM_TIME + t]= consumer14(t, tmp, modif14);
	tmp = (void *)get_struct15();
	consumption_wanted[14*SIM_TIME + t]= consumer15(t, tmp, modif15);

}

void power_assignment(int t){
	int i,j,power_assigned,temp;
	for(i=0;i<NPROD;i++){
		power_assigned = 0;
		for(j=0;j<NCONS;j++){
			if (assignment[i*NCONS + j] && ((consumption_wanted[j*SIM_TIME + t] - consumption_satisfied[j*SIM_TIME + t])>0)
				&& ((current_prod_storage[i]-power_assigned)>0)){
				temp = abs((current_prod_storage[i]-power_assigned)-(consumption_wanted[j*SIM_TIME + t] - consumption_satisfied[j*SIM_TIME + t]));
				consumption_satisfied[j*SIM_TIME + t]+= temp;
				power_assigned +=temp;
			}
		}
		prod_storage[i*SIM_TIME + t]=power_assigned;
	}
}

void init_assignment(void){
	int i,j;

	assignment = (int *)malloc(sizeof(int)*NPROD*NCONS);

	for(i=0;i<NPROD;i++){
		for(j=0;j<NCONS;j++){
			assignment[i*NCONS + j]=1;
		}
	}
	assignment[2*NCONS + 0]=0;
	assignment[3*NCONS + 1]=0;
	assignment[0*NCONS + 3]=0;
	assignment[1*NCONS + 3]=0;
	assignment[4*NCONS + 3]=0;
	assignment[0*NCONS + 4]=0;
	assignment[3*NCONS + 4]=0;
	assignment[4*NCONS + 4]=0;
	assignment[0*NCONS + 5]=0;
	assignment[4*NCONS + 5]=0;
	assignment[1*NCONS + 6]=0;
	assignment[0*NCONS + 8]=0;
	assignment[1*NCONS + 8]=0;
	assignment[2*NCONS + 8]=0;
	assignment[0*NCONS + 10]=0;
	assignment[2*NCONS + 11]=0;
	assignment[3*NCONS + 11]=0;
	assignment[4*NCONS + 11]=0;
	assignment[4*NCONS + 12]=0;
	assignment[0*NCONS + 13]=0;
	assignment[1*NCONS + 13]=0;
	assignment[0*NCONS + 14]=0;
	assignment[1*NCONS + 14]=0;
	assignment[2*NCONS + 14]=0;
}

void init_sim(int **a, int **b, int **c) {
	prod_storage = (int *)malloc(sizeof(int)*NPROD*SIM_TIME);
	current_prod_storage = (int *)malloc(sizeof(int)*NPROD);
	consumption_wanted = (int *)malloc(sizeof(int)*NCONS*SIM_TIME);
	consumption_satisfied = (int *)malloc(sizeof(int)*NCONS*SIM_TIME);
	init_prod();
	init_cons();
	*a = prod_storage;
	*b = consumption_satisfied;
	*c = consumption_wanted;
}
