/* view.c - main entry point */

#include <stdio.h>
#include "simulate.h"
#include "consumers.h"
#include "producers.h"

static FILE *production, *sat_cons, *wanted_cons;

void init_output() {
	if( (production = fopen( "production.txt", "w+" )) == NULL )
      printf( "The file could not be opened\n" );
	if( (sat_cons = fopen( "sat_cons.txt", "w+" )) == NULL )
      printf( "The file could not be opened\n" );
	if( (wanted_cons = fopen( "wanted_cons.txt", "w+" )) == NULL )
      printf( "The file could not be opened\n" );
}

void output(int *prod_storage, int *consumption_satisfied, int *consumption_wanted) {
	int t;
	/* print the results to files */
	/* print production */
	for(t=0;t<SIM_TIME;t++){
		fprintf(production,"%d\t",t);
		for(int i = 0;i < NPROD; i++){
			fprintf(production,"%d\t",prod_storage[i*SIM_TIME + t]);
		}
		fprintf(production,"\n");

		/* print the consumption */
		fprintf(sat_cons,"%d\t",t);
		fprintf(wanted_cons,"%d\t",t);
		for(int i = 0;i < NCONS; i++){
			fprintf(sat_cons,"%d\t",consumption_satisfied[i*SIM_TIME + t]);
			fprintf(wanted_cons,"%d\t",consumption_wanted[i*SIM_TIME + t]);
		}
		fprintf(sat_cons,"\n");
		fprintf(wanted_cons,"\n");
	}
}

void terminate_output() {
	fclose(production);
	fclose(sat_cons);
	fclose(wanted_cons);
}
