
open Staged
open Basetypes
open Float
open Tuple
open Vectoren
open Point
open Pointen
open Affine

let print s = Printf.printf "\n\n ==== %s ==== \n\n" s ;;

module V2R = VectorStaged (Float_Real_Exact) (Record2D)
module V3R = VectorStaged (Float_Real_Exact) (Record3D)
module P2R = En_Point (Float_Real_Exact) (V2R) (Record2D) 
module P3R = En_Point (Float_Real_Exact) (V3R) (Record3D) 

module AT2R = AffineTransformations (Float_Real_Exact) (V2R) (P2R) (Record2D)
module AT3R = AffineTransformations (Float_Real_Exact) (V3R) (P3R) (Record3D)

module Gen (AT : AFFINE) =
struct
  let translate _ =
    .< fun p v -> .~(
         let p' = of_atom .<p>.
         and v' = of_atom .<v>. in
         let t = AT.translation v' in
	 let y = AT.apply_p t p' in
         Staged.to_code y) >.
end

module G2R = Gen (AT2R) ;;
module G3R = Gen (AT3R) ;;

print "CUT MARKER" ;;

G2R.translate () ;;
G3R.translate () ;;

(*

- : unit = ()
#   - : ('a, AT2R.P.point -> AT2R.V.vector -> AT2R.P.point) 
code =                                                     
.<fun p_1 -> fun v_2 -> {c0 = (p_1.c0 +. v_2.c0); c1 = (p_1.
c1 +. v_2.c1)}>.                                           
# - : ('a, AT3R.P.point -> AT3R.V.vector -> AT3R.P.point) co
de =                                                       
.<fun p_1 ->
   fun v_2 ->
    {x = (p_1.x +. v_2.x); y = (p_1.y +. v_2.y); z = (p_1.z 
+. v_2.z)}>.                                               
# 

*)
