open Staged
open Basetypes
open Float
open Tuple
open Vectoren
open Pointen
open Hplane

let print s = Printf.printf "\n\n ==== %s ==== \n\n" s ;;

module Gen (H: HYPER_PLANE) =
struct
  module OP = Hplane_Operations (H)
  let dist () =
    .< fun ps p -> .~(
         (* Lift *)
         let p' = of_atom .<p>.
         and ps' = Array.to_list
	   (Array.init H.V.dim (fun i -> of_atom .<ps.(i)>.)) in
         (* create a hyperplane *)
         let h = H.of_points ps' in
         let d = OP.dist h p' in
         to_code d) >.

  let proj n =
    .< fun ps p -> .~(Staged.to_code (
         let points = Array.init n  (fun i -> of_atom .<ps.(i)>.) in
         let l = H.of_points (Array.to_list points) in
	 let v = OP.project l (of_atom .<p>.) in v)) >. 
end

module V1 = VectorStaged (Float_Real_Exact) (Tuple1D)
module P1 = En_Point (Float_Real_Exact) (V1) (Tuple1D)
module V2R = VectorStaged (Float_Real_Exact) (Record2D)
module P2R = En_Point (Float_Real_Exact) (V2R) (Record2D)
module V3R = VectorStaged (Float_Real_Exact) (Record3D)
module P3R = En_Point (Float_Real_Exact) (V3R) (Record3D)

(* Line is a 2D codimensional hypleplane *)
(* module L = Line (Float_Real_Exact)(V2R)(P2R) *)
module H0 = N_plane (Float_Real_Exact)(V1)(P1)
module H1 = N_plane (Float_Real_Exact)(V2R)(P2R)
module H2 = N_plane (Float_Real_Exact)(V3R)(P3R)

module GenDist1D = Gen (H0) ;;
module GenDist2D = Gen (H1) ;;
module GenDist3D = Gen (H2) ;;

print "CUT MARKER" ;;
print "HPLANE TEST" ;;

print "0-hyperplane dist ()" ;;
GenDist1D.dist () ;;
print "1-hyperplane dist ()" ;;
GenDist2D.dist () ;;
print "2-hyperplane dist ()" ;;
GenDist3D.dist () ;;

(*
print "Line proj ()" ;;
GH2.proj 2 ;;
print "Plane proj ()" ;;
GH3.proj 3 ;;
*)
