open Staged
open Basetypes
open Algebra
open Float
open Tuple
open Vectoren
open Point
open Pointen
open Hplane
open Vertex
open Simplex
open Inside

let print s = Printf.printf "\n\n ==== %s ==== \n\n" s ;;

module V1 = VectorStaged (Float) (Tuple1D)
module P1 = En_Point (Float) (V1) (Tuple1D)
module V2R = VectorStaged (Float) (Record2D)
module P2R = En_Point (Float) (V2R) (Record2D)
module V3R = VectorStaged (Float) (Record3D)
module P3R = En_Point (Float) (V3R) (Record3D)

module H1 = N_plane (Float)(V1)(P1)
module L = Line (Float)(V2R)(P2R)
module H3 = N_plane (Float)(V3R)(P3R)

module Gen (H : HYPER_PLANE) =
struct
  module Vx = Vertex(H.P)
  module S = N_Simplex(Vx)
  module IS = Inside (H) (S)

  let in_ n =
    .< fun ps p -> .~(Staged.to_code (
       let p = (of_atom .<p>.)
       and points = Array.init n (fun i -> of_atom .<ps.(i)>.) in
       let vs = Array.map (fun a -> Vx.create a) points in
       let vs = Array.to_list vs in
       let s = S.of_vertices vs in
       IS.in_ s p)) >.
end

module GSeg = Gen (H1) ;;
module GTri = Gen (L) ;;
module GTet = Gen (H3) ;;

print "CUT MARKER" ;;

print "INSIDE TEST" ;;

print "Inside simplex 2D Triangle in_ ()" ;;
GTri.in_ 3 ;;
print "Inside simplex 3D Tetra in_ ()" ;;
GTet.in_ 4 ;;
