open Staged
open Basetypes
open Algebra
open Float
open Tuple
open Vectoren
open Pointen
open Sphere
open Insphere

let print s = Printf.printf "\n\n ==== %s ==== \n\n" s ;;

module Gen (N : REALFIELD) (T : TUPLE) =
struct
  module V = VectorStaged (N) (T)
  module P = En_Point (N) (V) (T)
  module S = Sphere (N) (P)
  module IS = Insphere (S)
  let insphere () =
    .< fun ps p -> .~(Staged.to_code (
         let p' = of_atom .<p>.
         and ps' = Array.init (V.dim+1)
	               (fun i -> of_atom .<ps.(i)>.) in
         let s = S.of_points (Array.to_list ps') in
         IS.in_ s p')) >.
end
;;

module GS1 = Gen (Float_Real_Exact) (Tuple1D) ;;
module GS2 = Gen (Float_Real_Exact) (Record2D) ;;

print "CUT MARKER" ;;
print "INSPHERE TEST" ;;

print "GS1 " ;;
GS1.insphere () ;;
print "GS2 " ;;
GS2.insphere () ;;
