open Staged
open Basetypes
open Algebra
open Float
open Tuple
open Vectoren
open Pointen
open Hplane
open Orient


let print s = Printf.printf "\n\n ==== %s ==== \n\n" s ;;

module Gen (N : REALFIELD) (T : TUPLE) =
struct
  let col n =
    let module V = VectorStaged (N) (T) in
    let module P = En_Point (N) (V) (T) in
    let module H = N_plane (N) (V) (P) in
    let module HO = Orient (H) in
    .< fun ps p -> .~(Staged.to_code (
         let points = Array.init V.dim 
	               (fun i -> of_atom .<ps.(i)>.) in
         let l = H.of_points (Array.to_list points) in
         HO.col l (of_atom .<p>.))) >.
end

module GH1 = Gen (Float_Real_Exact) (Tuple1D) ;;
module GH2 = Gen (Float_Real_Exact) (Record2D) ;;
module GH3 = Gen (Float_Real_Exact) (Record3D) ;;

module Float_E6 = Float_Real_Inexact(struct let eps = 1e-6, .<1e-6>. end)

module GH1' = Gen (Float_E6) (Tuple1D) ;;
(* module GH2' = Gen (Float_Real_Inexact()) (Record2D) ;;
module GH3' = Gen (Float_Real_Inexact()) (Record3D) ;; *)

print "CUT MARKER" ;;
print "ORIENT TEST" ;;

print "GH1 col ()" ;;
GH1.col 1 ;;
print "GH2 col ()" ;;
GH2.col 2 ;;
print "GH3 plane col ()" ;;
GH3.col 3 ;;

print "GH1' col ()" ;;
GH1'.col 1 ;;
