
open Staged
open Basetypes
open Float
open Tuple
open Vectoren
open Point
open Pointen

let print s = Printf.printf "\n\n ==== %s ==== \n\n" s ;;

module V2R = VectorStaged (Float_Real_Exact) (Record2D)
module V3R = VectorStaged (Float_Real_Exact) (Record3D)
module P2R = Iso_Axis_Ordered_En_Point (Float_Real_Exact) (V2R) (Record2D) 
module P3R = Iso_Axis_Ordered_En_Point (Float_Real_Exact) (V3R) (Record3D) 

module Gen (P : ISO_AXIS_ORDERED_POINT) =
struct
  let sub _ =
    .< fun a b -> .~(Staged.to_code
	     (P.sub (of_atom .<a>.) (of_atom .<b>.))) >.
  let cmp_x _ =
    .< fun a b -> .~(Staged.to_code
         (P.lt 0 (of_atom .<a>.) (of_atom .<b>.))) >.
  let min _ =
    .< fun a b ->
      .~(let a = (of_atom .<a>.) and b = (of_atom .<b>.) in
         Staged.to_code (P.min 0 a b)) >.
  let dist _ =
    .< fun a b ->
      .~(let a = (of_atom .<a>.) and b = (of_atom .<b>.) in
         let v = P.sub a b in
         Staged.to_code (P.V.length v)) >.
end

module GP2R = Gen (P2R) ;;
module GP3R = Gen (P3R) ;;

print "CUT MARKER" ;;
print "POINT TEST" ;;

print "Point_En Record2d sub () " ;;
GP2R.sub () ;;
print "Point_En Record3d sub () " ;;
GP3R.sub () ;;

print "Point_En Record2d cmp_x () " ;;
GP2R.cmp_x () ;;
print "Point_En Record3d cmp_x () " ;;
GP3R.cmp_x () ;;

print "Point_En Record2d min () " ;;
GP2R.min () ;;
print "Point_En Record3d min () " ;;
GP3R.min () ;;

print "Point_En Record2d dist () " ;;
GP2R.dist () ;;
print "Point_En Record3d dist () " ;;
GP3R.dist () ;;
