open Staged
open Basetypes
open Code
open Util
open Algebra
open Float
open Rational
open Integer 

module GenericPower (R : RING) =
struct
  let rec power n x =
    match n with
    | 0 -> Staged.of_immediate R.one
    | n -> R.mul_s x (power (n-1) x)
end
;;

module type POWER_VAR =
sig
  module R : RING
  val n : int
end
;;

module PowerGen (PV : POWER_VAR) =
struct
  let power_gen () =
    let module GP = GenericPower(PV.R) in
    .< fun x -> .~(Staged.to_code
		     (GP.power PV.n (Staged.of_atom .<x>.))) >.
end
;;

module Float = Float_Ring_Exact

module Float1 = struct
  module R = Float
  let n = 1
end
;;

module Float2 = struct
  module R = Float
  let n = 2
end
;;

module Float3 = struct
  module R = Float
  let n = 3
end
;;

module Integer1 = struct
  module R = Integer_Ring
  let n = 1
end
;;

module Integer2 = struct
  module R = Integer_Ring
  let n = 2
end
;;

module Integer3 = struct
  module R = Integer_Ring
  let n = 3
end
;;

module PG_F1 = PowerGen(Float1);;
module PG_F2 = PowerGen(Float2);;
module PG_F3 = PowerGen(Float3);;

module PG_I1 = PowerGen(Integer1);;
module PG_I2 = PowerGen(Integer2);;
module PG_I3 = PowerGen(Integer3);;

(* module PowerRational = PowerGen(Rational_Ring);;
module PowerInteger = PowerGen(Integer_Ring);; *)

Printf.printf "\n\n ==== CUT MARKER ==== \n\n" ;;
Printf.printf "\n\n ==== POWER TEST ==== \n\n" ;;

Printf.printf "\n\n ==== PowerFloat power () ==== \n\n" ;;
(* PowerFloat.power_gen () ;; *)

PG_F1.power_gen () ;;
PG_F2.power_gen () ;;
PG_F3.power_gen () ;;

PG_I1.power_gen () ;;
PG_I2.power_gen () ;;
PG_I3.power_gen () ;;


(* PowerFloat.gen_power 2  ;;
PowerFloat.gen_power 3  ;;
PowerFloat.gen_power 6  ;; *)

(*
Printf.printf "\n\n ==== PowerRational power () ==== \n\n" ;;
PowerRational.gen_power 1  ;;
PowerRational.gen_power 2  ;;
PowerRational.gen_power 3  ;;
PowerRational.gen_power 6  ;;

Printf.printf "\n\n ==== PowerInteger power () ==== \n\n" ;;
PowerInteger.gen_power 1  ;;
PowerInteger.gen_power 2  ;;
PowerInteger.gen_power 3  ;;
PowerInteger.gen_power 6  ;;
*)
