open Staged
open Basetypes
open Float
open Tuple
open Vectoren
open Pointen
open Hplane
open Sphere

let print s = Printf.printf "\n\n ==== %s ==== \n\n" s ;;

module Gen (H : HSPHERE) =
struct
  module HO = Sphere_Operations (H.N)(H)

  let centre n =
    .< fun ps -> .~(
         let points = Array.init (n+1) (fun i -> of_atom .<ps.(i)>.) in
	 let ps = Array.to_list points in
	 let h = H.of_points ps in
         let cn = HO.centre h in
         Staged.to_code cn) >.

  let radius n =
    .< fun ps -> .~(
         let points = Array.init (n+1) (fun i -> of_atom .<ps.(i)>.) in
	 let ps = Array.to_list points in
	 let h = H.of_points ps in
         let cn = HO.radius h in
         Staged.to_code cn) >.

  let content n =
    .< fun ps -> .~(
         let points = Array.init (n+1) (fun i -> of_atom .<ps.(i)>.) in
	 let ps = Array.to_list points in
	 let h = H.of_points ps in
         let cn = HO.content h in
         Staged.to_code cn) >.

  let surface n =
    .< fun ps -> .~(
         let points = Array.init (n+1) (fun i -> of_atom .<ps.(i)>.) in
	 let ps = Array.to_list points in
	 let h = H.of_points ps in
         let cn = HO.surface h in
         Staged.to_code cn) >.
end
;;

module Float = Float_Real_Exact

module V1 = VectorStaged (Float) (Tuple1D)
module P1 = En_Point (Float) (V1) (Tuple1D)
module V2R = VectorStaged (Float) (Record2D)
module P2R = En_Point (Float) (V2R) (Record2D)
module V3R = VectorStaged (Float) (Record3D)
module P3R = En_Point (Float) (V3R) (Record3D)

module L = Sphere(Float)(P1)
module C = Sphere(Float)(P2R)
module S = Sphere(Float)(P3R)

module G1 = Gen(L) ;;
module G2 = Gen(C) ;;
module G3 = Gen(S) ;;

print "CUT MARKER" ;;
print "SPHERE TEST" ;;

print "Sphere 1 centre ()" ;;
G1.centre 1 ;;
print "Sphere 2 centre ()" ;;
G2.centre 2 ;;
print "Sphere 3 centre ()" ;;
G3.centre 3 ;;

print "Sphere 1 radius ()" ;;
G2.radius 1 ;;
print "Sphere 2 radius ()" ;;
G2.radius 2 ;;
print "Sphere 3 radius ()" ;;
G3.radius 3 ;;

print "Sphere 1 content ()" ;;
G2.content 1 ;;
print "Sphere 2 content ()" ;;
G2.content 2 ;;
print "Sphere 3 content ()" ;;
G3.content 3 ;;

print "Sphere 1 surface ()" ;;
G2.surface 1 ;;
print "Sphere 2 surface ()" ;;
G2.surface 2 ;;
print "Sphere 3 surface ()" ;;
G3.surface 3 ;;
