open Staged
open Basetypes
open Float
open Vector
open Vectoren
open Tuple

(* Vector 2D with record representation *)
module V2R = VectorStaged (Float_Real_Exact)(Record2D)
(* Vector 2D with pair representation *)
module V2P = VectorStaged (Float_Real_Exact)(Pair2D)
(* Vector 3D with record representation *)
module V3R = VectorStaged (Float_Real_Exact)(Record3D)
(* Vector nD with array representation *)
(* module VnA = VectorStaged (Float_Real_Exact)(ArrayTuple) *)

module Gen (V : VECTOR) =
struct
  let length _ =
    .< fun a -> .~(Staged.to_code (V.length (of_atom .<a>.))) >.

  let sub _ =
    .< fun a b -> .~(Staged.to_code (V.sub (of_atom .<a>.) (of_atom .<b>.))) >.

  let dist _ =
    .< fun a b -> .~(Staged.to_code (
	 V.length (V.sub (of_atom .<a>.) (of_atom .<b>.)))) >.

  let unit_vec _ =
    .< fun a b -> .~(Staged.to_code (
	 V.direction (V.sub (of_atom .<a>.) (of_atom .<b>.)))) >.

  let dot _ =
    .< fun a b -> .~(Staged.to_code (
	 V.dot (of_atom .<a>.) (of_atom .<b>.))) >.
end
;;

module GV2R = Gen(V2R);;
module GV2P = Gen(V2P);;
module GV3R = Gen(V3R);;

Printf.printf "\n\n ==== CUT MARKER ==== \n\n" ;;
Printf.printf "\n\n ==== VECTOR TEST ==== \n\n" ;;

Printf.printf "\n\n ==== VectorStaged Record2D length () ==== \n\n" ;;
GV2R.length () ;;
Printf.printf "\n\n ==== VectorStaged Pair2D length () ==== \n\n" ;;
GV2P.length () ;;
Printf.printf "\n\n ==== VectorStaged Record3D length () ==== \n\n" ;;
GV3R.length () ;;

Printf.printf "\n\n ==== VectorStaged Record2D sub () ==== \n\n" ;;
GV2R.sub () ;;
Printf.printf "\n\n ==== VectorStaged Pair2D sub () ==== \n\n" ;;
GV2P.sub () ;;
Printf.printf "\n\n ==== VectorStaged Record3D sub () ==== \n\n" ;;
GV3R.sub () ;;

Printf.printf "\n\n ==== VectorStaged Record2D dist () ==== \n\n" ;;
GV2R.dist () ;;
Printf.printf "\n\n ==== VectorStaged Pair2D dist () ==== \n\n" ;;
GV2P.dist () ;;
Printf.printf "\n\n ==== VectorStaged Record3D dist () ==== \n\n" ;;
GV3R.dist () ;;

Printf.printf "\n\n ==== VectorStaged Record2D unit_vec () ==== \n\n" ;;
GV2R.unit_vec () ;;
Printf.printf "\n\n ==== VectorStaged Pair2D unit_vec () ==== \n\n" ;;
GV2P.unit_vec () ;;
Printf.printf "\n\n ==== VectorStaged Record3D univ_vec () ==== \n\n" ;;
GV3R.unit_vec () ;;

Printf.printf "\n\n ==== VectorStaged Record2D dot () ==== \n\n" ;;
GV2R.dot () ;;
Printf.printf "\n\n ==== VectorStaged Pair2D dot () ==== \n\n" ;;
GV2P.dot () ;;
Printf.printf "\n\n ==== VectorStaged Record3D dot () ==== \n\n" ;;
GV3R.dot () ;;

