open Staged

module Int =
struct
  type 'a t = ('a, int) staged
  let random_n s = Random.int s
  let random_c s = .< Random.int .~s >.
  let random = function
    | Now s -> Now (Random.int s)
    | Later s -> of_comp .< Random.int .~(s.c) >.

  let zero = 0
  (* let succ i = mk_unary 
      { unow = (fun i -> i + 1); ulater = (fun i -> .<.~i + 1>.) } i *)
end

(* String *)
module String =
struct
  type 'a t = ('a, string) staged
  
  let concat_op =
    { bnow = (fun x y -> x ^ y); 
      blater = (fun x y -> lift_comp .<.~(x.c) ^ .~(y.c)>.) }
  let concat_b = { bop = concat_op; uelem = ""}
  let concat_s s t = mk_monoid concat_b s t
end

(* ***** BOOLEAN TYPE ***** *)

(* This type is too important to try to coerce it into generic methods,
 * it's best just to give it a solid implementation.
 * Since we have boolean operations in the base language, first implement
 * the lifted version.  From that, do a staged version. 
 * For brevity: c = code, s = staged *)
module Bool =
struct
  type 'a b = ('a,bool) staged
  let false_ = false
  let true_ = true

  let not_b = { unow = (fun b -> not b);
                ulater = (fun b -> lift_comp .<not .~(b.c)>.) }
  let not_s b = mk_unary not_b b

  let is_true = { unow = (fun b -> b);
                  ulater = (fun b -> lift_comp .<.~(b.c)>.) }
  let is_false = { unow = (fun b -> not b);
                  ulater = (fun b -> lift_comp .<not .~(b.c)>.) }
  
  let and_op = { bnow = (fun x y -> x && y);
		 blater = (fun x y -> lift_comp .< .~(x.c) && .~(y.c) >.) }
  let and_mon = { bop = and_op; uelem = true }
  let or_op = { bnow = (fun x y -> x || y);
		blater = (fun x y -> lift_comp .< .~(x.c) || .~(y.c) >.) }
  let or_mon = { bop = or_op; uelem = false }
  let and_b = { monp =  or_mon; mont = and_mon}
  let and_s a b = mk_ring and_b a b

  let or_b = { monp =  and_mon; mont = or_mon}
  let or_s a b = mk_ring or_b a b

  let eq x y =
    let bnow x y = x = y
    and blater x y = lift_comp .< .~(x.c) = .~(y.c) >. in
    mk_binary { bnow = bnow; blater = blater } x y
end
