
open Staged
open Basetypes

let seq' a b = .< begin .~a ; .~b end >.

let seq a b = mk_binary
  { bnow = (fun x y -> (x; y));
    blater = fun x y -> lift_comp .< begin .~(to_code a) ;
                                 .~(to_code b) end >. } a b

(* let rec seq = function
  | [] -> Now ()
  | x :: xs .< begin x; .~(to_code xs) end >. *)

module type STAGED =
sig
  type t
  type 'a t_s
  val of_immediate : t -> 'a t_s
  val of_code : ('a, t) code -> 'a t_s
  val to_later : 'a t_s -> 'a t_s
  val to_code : 'a t_s -> ('a, t) code
  val is_now : 'a t_s -> bool
  val is_later : 'a t_s -> bool
end

(* The statment about semantic below is not well-typed
 * [[ife_ c a b]] = { a,               if c = Now true
 *                  { b,               if c = Now false
 *                  { <if ~c then ~a
 *                           else ~b>, if c = Later _
 * @TODO Make sure that ife_ is lazy in 'a' and 'b'.
*)
let ife c a b to_code = match c with
  | Now c -> if c then a else b
  | Later c ->
      of_comp (.< if .~(c.c) then .~(to_code a)
                               else .~(to_code b) >.)

(* if_ = ife_ + side effects. Not needed for now *)
(* let if_ c a = ife_ c a (Now ()) *)

(* let let_ ce exp = mk_binary
  { bnow = fun c e -> c e;
    blater = .< let _v = .~c in
                  .~ (to_code (exp (of_code .<_v>.))) >. } ce exp
*)

let let_ ce exp =
  match ce with
  | Now _ -> exp ce
  | Later c when c.a = true -> exp ce
  | Later c ->
      of_comp .< let _v = .~(c.c) in
        .~ (to_code (exp (of_atom .<_v>.))) >.

let letc_ ce exp =
  if ce.a then exp ce
  else lift_comp .< let _v = .~(ce.c) in
    .~(let r = exp (lift_atom .<_v>.) in r.c) >.

let letp ce exp = match ce with
  | Now v -> Now (exp.unow v)
  | Later c when c.a -> 
      Later (exp.ulater (lift_atom c.c))
  | Later c -> Later 
      {c = .< let v = .~(c.c) in
          .~((exp.ulater (lift_atom .<v>.)).c) >.;
       a = false}

(*

(* Cohen A, Donadio S, Garzaran M, et al.
   In search of a program generator to implement generic
   transformations for high-performance computing. 
   Science of Computer Programming. 2006;62(1):25-46.
   Available at: http://dx.doi.org/10.1016/j.scico.2005.10.013. *)

let rec full_unroll lb ub body =
  if lb > ub then .< () >.
  else if lb = ub then body .< lb >.
  else .< begin .~(body .<lb>.); .~(full_unroll (lb+1) ub body) end >.
(* int -> int -> (('a, int) code -> ('b, unit) code) -> ('b, unit) code *)

let partial_unroll lb ub factor body =
  let number = (ub-lb+1)/factor in
  let bound = number*factor in
  .< begin
    for ii = 0 to number-1 do
      .~(full_unroll 0 (factor-1) (fun i -> body .< ii*factor+lb + .~i >.))
    done;
    for i = bound+lb to ub do
      .~(body .< i >.)
    done
  end >.
(* int -> int -> int -> (('a, int) code -> ('a, unit) code) -> ('a, unit) code *)

*)
