
open Staged
open Basetypes
open Util

module type FOLDABLE =
sig
  type 'a t
  val map : ('a, 'b, 'c) unary_fun ->
                  ('a, 'b t) staged -> ('a, 'c t) staged

  val map2 : ('a, 'b, 'b, 'd) binary_fun ->  ('a, 'b t) staged ->
                  ('a, 'b t) staged -> ('a, 'd t) staged

  val fold : ('a, 'b, 'c, 'c) binary_fun -> 'c ->
                  ('a, 'b t) staged -> ('a, 'c) staged

  val mapfold : ('a, 'b, 'd) unary_fun -> ('a, 'd, 'c, 'c) binary_fun ->
                    'c -> ('a, 'b t) staged -> ('a, 'c) staged

  val map2fold : ('a, 'b, 'c, 'd) binary_fun -> ('a, 'd, 'e, 'e) binary_fun ->
                    'e -> ('a, 'b t) staged ->
		      ('a, 'c t) staged -> ('a, 'e) staged
end

