open Staged
open Basetypes
open Util
open Algebra
open Point
open Hplane
open Vertex
open Simplex
open Orient

(* ***** Point inside simplex ***** *)

(* @TODO actually everyting is done Later *)

type point_inside_simplex =
  { side : Side.t ;
    face : int option }

module Inside
  (H : HYPER_PLANE)
  (S : SIMPLEX with module V.P = H.P)
   =
struct
  module Orn = Orient (H)

  let hyperplanes s =
    (* get all the faces *)
    let fs = S.ofaces s in
    (* build a hyperplane out of points of every face *)
    let hplane_of_face f =
      H.of_points (List.map S.V.point (S.vertices f)) in
    List.map hplane_of_face fs

  let in_ s p =
    let hs = hyperplanes s in
    let o_ccw = List.map (fun h -> Orn.ccw h p) hs in
    for_all (fun b -> Bool.eq (Now Bool.true_) b) o_ccw

  let out s p =
    let hs = hyperplanes s in
    let o_cw = List.map (fun h -> Orn.cw h p) hs in
    exists (fun b -> b) o_cw

  let on s p =
    let hs = hyperplanes s in
    let o_ccw_or_col = List.map (fun h -> Orn.ccw_or_col h p) hs
    and o_col = List.map (fun h -> Orn.col h p) hs in
    let c0 = for_all (fun b -> b) o_ccw_or_col in
    let i = (findi (fun b -> b) o_col) in
    let c1 = Bool.not_s (Bool.eq i (Now (List.length o_col))) in
    (Bool.and_s c0 c1), i

  let in_or_on s p = Bool.not_s (out s p)
end

(* TEST DATA *)

(* val find : ('a -> bool) -> 'a list -> 'a *)

(*

let p0 = P.PNow ((Now 0.), (Now 0.)) ;;
let p1 = P.PNow ((Now 10.), (Now 0.)) ;;
let p2 = P.PNow ((Now 0.), (Now 10.)) ;;
let p = P.PNow ((Now 1.), (Now 1.)) ;;
let t = (p0, p1, p2) ;;

module I = Inside(Float) (P)(Triangle) ;;
let inside2d = I.inside
let i2gen () =
.< fun ((x0, y0), (x1, y1), (x2, y2)) (x,y) -> 
  .~(Staged.to_code (
  let p0 = P.PNow ((Later .<x0>.), (Later .<y0>.))
  and p1 = P.PNow ((Later .<x1>.), (Later .<y1>.))
  and p2 = P.PNow ((Later .<x2>.), (Later .<y2>.))
  and p  = P.PNow ((Later .<x>.), (Later .<y>.)) in
  let t  = p0, p1, p2 in
  inside2d t p))
>.

.<fun ((x0_1, y0_2), (x1_3, y1_4), (x2_5, y2_6)) ->
   fun (x_7, y_8) ->
    (((match
         let x_9 =
          ((x1_3 *. (y2_6 +. (~-. y_8))) +.
            ((~-. (y1_4 *. (x2_5 +. (~-. x_7)))) +.
              ((x2_5 *. y_8) +. (~-. (y2_6 *. x_7))))) in
         if (x_9 = 0.) then (Algebra.Zero)
         else if (x_9 > 0.) then (Algebra.Pos)
         else (Algebra.Neg) with
       | Algebra.Pos -> (IN)
       | Algebra.Neg -> (OUT)
       | Algebra.Zero -> (ON)) =
       (match
          let x_10 =
           ((x2_5 *. (y0_2 +. (~-. y_8))) +.
             ((~-. (y2_6 *. (x0_1 +. (~-. x_7)))) +.
               ((x0_1 *. y_8) +. (~-. (y0_2 *. x_7))))) in
          if (x_10 = 0.) then (Algebra.Zero)
          else if (x_10 > 0.) then (Algebra.Pos)
          else (Algebra.Neg) with
        | Algebra.Pos -> (IN)
        | Algebra.Neg -> (OUT)
        | Algebra.Zero -> (ON))) &&
      ((match
          let x_10 =
           ((x2_5 *. (y0_2 +. (~-. y_8))) +.
             ((~-. (y2_6 *. (x0_1 +. (~-. x_7)))) +.
               ((x0_1 *. y_8) +. (~-. (y0_2 *. x_7))))) in
          if (x_10 = 0.) then (Algebra.Zero)
          else if (x_10 > 0.) then (Algebra.Pos)
          else (Algebra.Neg) with
        | Algebra.Pos -> (IN)
        | Algebra.Neg -> (OUT)
        | Algebra.Zero -> (ON)) =
        (match
           let x_11 =
            ((x0_1 *. (y1_4 +. (~-. y_8))) +.
              ((~-. (y0_2 *. (x1_3 +. (~-. x_7)))) +.
                ((x1_3 *. y_8) +. (~-. (y1_4 *. x_7))))) in
           if (x_11 = 0.) then (Algebra.Zero)
           else if (x_11 > 0.) then (Algebra.Pos)
           else (Algebra.Neg) with
         | Algebra.Pos -> (IN)
         | Algebra.Neg -> (OUT)
         | Algebra.Zero -> (ON))))>.
# 

let i2 = .! i2gen () ;;

i2 ((0., 0.), (10., 0.), (0., 10.)) (~-. 1., ~-. 1.) ;;

module Ornt = Orient(Float)(P)(Line) ;;

let orient = Ornt.orient

let orient2d_gen () =
.< fun ((x0, y0), (x1, y1)) (x,y) -> 
  .~(Staged.to_code (
  let p0 = P.PNow ((Later .<x0>.), (Later .<y0>.))
  and p1 = P.PNow ((Later .<x1>.), (Later .<y1>.))
  and p  = P.PNow ((Later .<x>.), (Later .<y>.)) in
  let l  = p0, p1 in
  orient l p))
>.

*)
