open Staged
open Basetypes
open Algebra

module Integer_Set (* : SET *) =
struct
  type n = int
  type 'a ns = ('a, n) staged
  type 'a rel = 'a ns -> 'a ns -> 'a Bool.b
  type 'a bin = 'a ns -> 'a ns -> 'a ns
  let to_string_b = 
      { unow = (fun x -> string_of_int x);
        ulater = (fun x -> lift_comp .< string_of_int .~(x.c)>.) }
  let to_string_s v = mk_unary to_string_b v

  let eq_b = { bnow = (fun x y -> x=y);
               blater = (fun x y -> lift_comp .<.~(x.c) = .~(y.c)>.) }
  let eq_s a b = mk_binary eq_b a b
  let neq_b = { bnow = (fun x y -> x <> y);
                blater = (fun x y -> lift_comp .<.~(x.c) <> .~(y.c)>.) }
  let neq_s a b = mk_binary neq_b a b
  let eq_tol = eq_s
  let of_int x = x
end

module Integer_Normed_Set (* : NORMED_SET *) =
struct
  include Integer_Set
  let norm_b = { unow = (fun x -> if x < 0 then -x else x);
                 ulater = (fun x -> lift_comp (
		   if x.a then .< if .~(x.c) < 0 then - .~(x.c) else .~(x.c) >.
		   else .< let x = .~(x.c) in if x < 0 then -x else x >.)) }
  let norm_s x = mk_unary norm_b x
end

(* (Z,+,0) monoid *)
module Integer_Add_Monoid (* : MONOID *) =
struct
  include Integer_Set
  let zero = 0
  let plus_op = { bnow = (fun x y -> x+y); 
                  blater = (fun x y -> lift_comp .<.~(x.c) + .~(y.c)>.); }
  let plus_b = { bop = plus_op; uelem = zero }
  let plus_s a b = mk_monoid plus_b a b
end

module Integer_Add_Normed_Monoid (* : NORMED_MONOID *) =
struct
  include Integer_Normed_Set
  let zero = 0
  let plus_op = { bnow = (fun x y -> x+y); 
                  blater = (fun x y -> lift_comp .<.~(x.c) + .~(y.c)>.); }
  let plus_b = { bop = plus_op; uelem = zero }
  let plus_s a b = mk_monoid plus_b a b
end

module Integer_Ring (* : NORMED_MONOID *) (* : RING *) =
struct
  include Integer_Set
  let zero = 0
  let one = 1
  let negone = -1
  let two = 2

  let add_op = { bnow = (fun x y -> x+y); 
                 blater = (fun x y -> lift_comp .<.~(x.c) + .~(y.c)>.); }
  let add_b = { bop = add_op; uelem = 0 }
  let add_s a b = mk_monoid add_b a b

  let neg_b = { unow = (fun x -> - x);
		ulater = (fun x -> lift_comp .< - .~(x.c) >.) }
  let neg_s x = mk_unary neg_b x

  let sub_b =
    { bnow = (fun x y -> add_b.bop.bnow x (neg_b.unow y));
      blater = (fun x y -> lift_comp .< .~(x.c) - .~(y.c) >.) }
  let sub_s a b = match a,b with
    | a, Now zero -> a
    | Now zero, b -> neg_s b
    (* | Later a, Later b when a = b -> Now zero *)
    | a, b -> mk_binary sub_b a b

  let mul_op = { bnow = (fun x y -> x*y); 
                 blater = (fun x y -> lift_comp .<.~(x.c) * .~(y.c)>.) }
  let mul_mon = { bop = mul_op; uelem = one }
  let mul_b = { monp = add_b; mont = mul_mon}
  let mul_s x y =
    if x = (Now negone) then neg_s y
    else if y = (Now negone) then neg_s x
    else mk_ring mul_b x y

  let abs_b = { unow = (fun x -> if x < 0 then -x else x);
                ulater = (fun x -> lift_comp (
		    if x.a then .< if .~(x.c) < 0 then - .~(x.c) else .~(x.c) >.
		           else .< let x = .~(x.c) in if x < 0 then -x else x >.)) }
  let abs_s x = mk_unary abs_b x

  let eps = 0
  let eps_c = .<0>.
  let sgn x =
    let sgn_now x = Sign.bind (Now (x > eps)) (Now (x >= -eps && x <= eps))
      (Now (x < -eps)) (Now (x >= -eps)) (Now (x <= eps))
    and sgn_later x = Sign.bind (Later (lift_comp .< .~(x.c) > .~eps_c >.))
      (Later (lift_comp .< let x = .~(x.c) and eps = .~eps_c in
                 x >= -eps &&  x <= eps >.))
      (Later (lift_comp .< .~(x.c) < - .~eps_c >.))
      (Later (lift_comp .< .~(x.c) >= - .~eps_c >.))
      (Later (lift_comp .< .~(x.c) <= .~eps_c >.)) in
    match x with
    | Now x -> sgn_now x
    | Later x -> sgn_later x
  let pow x y = failwith "not implemented"
  let int_pow n x = failwith "not implemented"

  (* NORMED_MONOID stuff *)
  let plus_b = add_b
  let plus_s = add_s
  let norm_b = abs_b
  let norm_s = abs_s
end

