open Staged
open Basetypes
open Code

(* util *)
let rec codelist_to_listcode =
  function [] -> .<[]>.
  | x :: xs -> .< .~x :: .~(codelist_to_listcode xs) >.

(* [| .<x>.; .<y>. |] -> .< [| x; y |] >.*)
let codearray_to_arraycode arr =
  let l = Array.to_list arr in
  let lc = codelist_to_listcode l in
  .< Array.of_list .~lc >.

let rec for_all p = function
  | [] -> Now true
  | x :: xs -> Bool.and_s (p x) (for_all p xs)

let rec exists p = function
  | [] -> Now false
  | x :: xs -> Bool.or_s (p x) (exists p xs)

let findi p =
  let rec findi i = function
    | [] -> Now i
    | x :: xs -> Code.ife (p x) (Now i) (findi (i+1) xs) to_code
  in findi 0
