open Staged
open Basetypes
open Algebra

(* Operations of vector space:
     - vector -> vector
     vector * scalar -> scalar
     vector [+-] vector -> vector
     vector [./] scalar -> vector
     point - point -> vector
     point [+-] vector -> point
     point + point -> undef
*)

(* Free Vectors *)
module type VECTOR =
sig
  module N : REALFIELD
  type vector
  type 'a vector_s = ('a, vector) staged
  type coordinate_enum = int
  val dim : int
  val zero : int -> 'a vector_s
  val to_expr : 'a vector_s -> ('a, vector) code_expr
  val to_code : 'a vector_s -> ('a, vector) code
  val of_immediate : vector -> 'a vector_s
  val of_expr : ('a, vector) code_expr -> 'a vector_s
  val of_coords : 'a N.ns list -> 'a vector_s
  (* equality *)
  val eq : 'a vector_s -> 'a vector_s -> 'a Bool.b
  val neq : 'a vector_s -> 'a vector_s -> 'a Bool.b
  (* Affine coordinates relative to a cartesian frame.
   * The frame itself is a @TODO. *)
  val coord : 'a vector_s -> coordinate_enum -> 'a N.ns
  val mirror : 'a vector_s -> 'a vector_s
  val add : 'a vector_s -> 'a vector_s -> 'a vector_s
  val sub : 'a vector_s -> 'a vector_s -> 'a vector_s
  val scale : 'a vector_s -> 'a N.ns -> 'a vector_s
  val shrink : 'a vector_s -> 'a N.ns -> 'a vector_s
  val dot : 'a vector_s -> 'a vector_s -> 'a N.ns
  (* binary cross product *)
  val bcross : 'a vector_s -> 'a vector_s -> 'a vector_s
  (* generalized cross product of n-vectors *)
  val gcross : 'a vector_s list -> 'a vector_s
  val length2 : 'a vector_s -> 'a N.ns
  val length : 'a vector_s -> 'a N.ns
  (* unit vector *)
  val direction : 'a vector_s -> 'a vector_s
end



