#include <math.h>

void NewtonStepND (
  double Xprevious0,
  double Xprevious1,
  double Xprevious2,
  double *r)
{
  double r0;
  double r1;
  double r2;
  double t1;
  double t10;
  double t9;
  t1 = Xprevious0 * Xprevious0;
  r0 = (0.1e1 - (t1 + 0.3e1) / (t1 + 0.1e1) / 0.3e1) * Xprevious0;
  t9 = exp(0.1e1 - Xprevious1);
  t10 = Xprevious1 * Xprevious1;
  r1 = Xprevious1 + (t9 + 0.2400e4 * Xprevious1 - 0.8000e4 + (0.8e1 * Xprevious1 - 0.240e3) * t10) / (t9 - 0.24e2 * t10 + 0.480e3 * Xprevious1 - 0.2400e4);
  r2 = 0.4e1;
  r[0] = r0;
  r[1] = r1;
  r[2] = r2;
  return;
}
