#include <stdio.h>

#define N             6
#define iter         30
#define initVector0 -10.0
#define initVector1  10.0
#define initVector2 -10.0
#define initVector3  10.0
#define initVector4  10.0
#define initVector5 -10.0

double NewtonStepND (double, double, double, double, double, double, double*);

void printVector (double *X, int iterNum)
{
	int i;
	printf ("\nX[%d] = [ ", iterNum);
	for (i = 0; i < N; i++)
		printf ("%.10lf ", X[i]);
	printf ("]");
}

int main (void)
{	
	int i;
	double Xnext[N];

        Xnext[0] = initVector0;
        Xnext[1] = initVector1;
        Xnext[2] = initVector2;
        Xnext[3] = initVector3;
        Xnext[4] = initVector4;
        Xnext[5] = initVector5;
	
	printVector (Xnext, 0);
	for (i = 0; i < iter; i++)
	{
		NewtonStepND (Xnext[0],Xnext[1],Xnext[2],Xnext[3],Xnext[4],Xnext[5],Xnext);
		printVector (Xnext, i+1);
	}
	printf ("\n\n");

	return 0;
}
