/* generating all the switchings.
   each switching is represented as an array of integers 
   of length n of 0 and 1. There are no more than n/2 1's.
   in total there must be 2^{n-1} switchings.

   The code is called only once to generate them,
   and thus is not so much optimized.
*/

#include "canon_libcanon.h"
#include <stdio.h>

static int next_sw(const int n, const int ne, const int a[], int b[]) {
  int ctr_1, f1, f0, i;
  f1 = -1; /* find the first 1 */
  while(!a[++f1]);
  if (f1 + ne >= n) return 0; /* that's the last one */
  
  f0 = f1; /* find the first 0 */
  ctr_1 = 0; /* count the number of 1s we pass */
  while(a[++f0]) ++ctr_1;

  for (i = 0; i < ctr_1; ++i) b[i] = 1; /* write lex. max. thing here */
  for (     ; i < f0; ++i) b[i] = 0;

  b[f0] = 1;

  for (i = f0 + 1 ; i < n; ++i) b[i] = a[i]; /* copy the rest unchanged */
  return 1;
}

static void gen_sw(const int n, int *a) {
  int ne, lim;
  int *p;
  p = a;
  lim = n/2;
  if (2*lim < n) ++lim;
  for (ne = 1; ne < lim; ++ne) {
    int j;

    /* generate the 1st switching with ne 1's */
    int *q;
    q = p;
    for (j = 0; j < ne; j++) *(q++) = 1;

    /* generate all the other switchings with ne 1's */
    while (next_sw(n, ne, p, p+n)) p += n;
    p += n;
  }

  /* even n needs a special treatment - not to generate complements */
  if (2*lim == n)  {
    int j;

    /* generate the 1st switching with ne 1's */
    int *q;
    q = p;
    for (j = 0; j < ne; j++) *(q++) = 1;

    /* generate all the other switchings with ne 1's */
    while (next_sw(n-1, ne-1, p+1, p+n+1)) {
      p += n;
      *p = 1;
    }
  }
}

/* the entry point to call in this module */
int *allsw(const int n) {
  int swnum;
  int *a;
  swnum = e2(n-1);
  a = (int*)calloc(n*swnum, sizeof(int));
  gen_sw(n, a);
  return a;
}
