/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *																			       *
 *								Metric polytope									   *
 *																				   *
 *								  Source file									   *
 *																				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include"owe_header.h"

void metric_polytope_initialize(unsigned char n) {
	
	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*  metric_polytope_initialize
	*  --------------------------
	*  Parameters:
	*		- n: metric polytope to set (3 to 9).
	*
	*	This function initializes the element of the owe_setting variable structure that corresponds
	*	to the metric polytope for use in the computation, setting its attributes:
	*														dimension
	*														inequality_count
	*														inequalities
	*
	*	to its corresponding values according to the input parameter.
	*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

	/* Variable used for preparing the cut and anticut canonical representatives. */
	unsigned int dimension;

	/* Assign the value to the metric polytope owe_setting variable. */
	owe_setting.metric_polytope.n = n;

	/* Assign to the owe_setting values the corresponding metric polytope data. */
	switch(n) {
		case 3:
			owe_setting.metric_polytope.dimension = 3;
			owe_setting.metric_polytope.inequality_count = 4;
			owe_setting.metric_polytope.inequalities = (metric_polytope_inequality) mp3_h_rep;
			break;
		case 4:
			owe_setting.metric_polytope.dimension = 6;
			owe_setting.metric_polytope.inequality_count = 16;
			owe_setting.metric_polytope.inequalities = (metric_polytope_inequality) mp4_h_rep;
			break;
		case 5:
			owe_setting.metric_polytope.dimension = 10;
			owe_setting.metric_polytope.inequality_count = 40;
			owe_setting.metric_polytope.inequalities = (metric_polytope_inequality) mp5_h_rep;
			break;
		case 6:
			owe_setting.metric_polytope.dimension = 15;
			owe_setting.metric_polytope.inequality_count = 80;
			owe_setting.metric_polytope.inequalities = (metric_polytope_inequality) mp6_h_rep;
			break;
		case 7:
			owe_setting.metric_polytope.dimension = 21;
			owe_setting.metric_polytope.inequality_count = 140;
			owe_setting.metric_polytope.inequalities = (metric_polytope_inequality) mp7_h_rep;
			break;
		case 8:
			owe_setting.metric_polytope.dimension = 28;
			owe_setting.metric_polytope.inequality_count = 224;
			owe_setting.metric_polytope.inequalities = (metric_polytope_inequality) mp8_h_rep;
			break;
		case 9:
			owe_setting.metric_polytope.dimension = 36;
			owe_setting.metric_polytope.inequality_count = 336;
			owe_setting.metric_polytope.inequalities = (metric_polytope_inequality) mp9_h_rep;
			break;
	}
	
	/* Allocate memory for the metric polytope cut and anticut canonical representatives. */
	if(!(owe_setting.metric_polytope.cut_canonical_representative = (coordinate) malloc(sizeof(coordinate_item)*(owe_setting.metric_polytope.dimension+1)))) owe_error_handler_raise_error("memory allocation error (coordinate variable : metric_polytope_initialize function : metric_polytope ADT)", 1);
	if(!(owe_setting.metric_polytope.anticut_canonical_representative = (coordinate) malloc(sizeof(coordinate_item)*(owe_setting.metric_polytope.dimension+1)))) owe_error_handler_raise_error("memory allocation error (coordinate variable : metric_polytope_initialize function : metric_polytope ADT)", 1);


	/* Assign values to the cut and anticut coordinates and denominator. */
	dimension = owe_setting.metric_polytope.dimension;
	owe_setting.metric_polytope.cut_canonical_representative[dimension] = 1;
	owe_setting.metric_polytope.anticut_canonical_representative[dimension] = 3;

	while(dimension) {
		dimension--;
		owe_setting.metric_polytope.cut_canonical_representative[dimension] = 0;
		owe_setting.metric_polytope.anticut_canonical_representative[dimension] = 2;
	}

	
	/* Obtain the canonical representative of the cut. */
	canon((int)*(owe_setting.metric_polytope.anticut_canonical_representative+owe_setting.metric_polytope.dimension),(int*)owe_setting.metric_polytope.anticut_canonical_representative);

}


void metric_polytope_finalize(void) {
		
	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*  metric_polytope_finalize
	*  ------------------------
	*
	*	This function frees the memory taken by the metric polytope data, particulary the
	*	cut and anticut canonical representative coordinates (and denominator).
	*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

	free(owe_setting.metric_polytope.cut_canonical_representative);
	free(owe_setting.metric_polytope.anticut_canonical_representative);
}
