/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *																			       *
 *						Next Iteration Input Generator							   *
 *																				   *
 *								 Header file									   *
 *																				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Next iteration file name definition. */
#define next_iteration_input_file_name "next_iteration_input.txt"

/* Next iteration file contents template */
#define next_iteration_input_template_text "\
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n\
*                                                                           *\n\
*                   Input parameter file for OWE                            *\n\
*                                                                           *\n\
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n\
\n\
* Parameter: metric polytope\n\
* Description: integer number (greater or equal than 3) that identifies the\n\
*              metric polytope to work on.\n\
\n\
   metric polytope = %u\n\
\n\
\n\
\n\
* Parameters: ""incidence lower bound"" and ""incidence upper bound""\n\
* Description: incidence range that will be used during computation to\n\
*              determine which orbits to compute. Both positive integer\n\
*              numbers, ""incidence upper bound"" must be equal or greater\n\
*              than ""incidence lower bound"".\n\
\n\
   incidence lower bound = %lu\n\
\n\
   incidence upper bound = %lu\n\
\n\
\n\
\n\
* Parameters: ""adjacency lower bound"" and ""adjacency upper bound""\n\
* Description: adjacency range that will be used during computation to\n\
*              determine which orbits to compute. Both positive integer\n\
*              numbers, ""adjacency upper bound"" must be equal or greater\n\
*              than ""adjacency lower bound"".\n\
\n\
   adjacency lower bound = %lu\n\
\n\
   adjacency upper bound = %lu\n\
\n\
\n\
\n\
* Parameter: double description time limit\n\
* Description: maximum amount of time that the double description method\n\
*              will be allowed to run (in minutes) in the orbit computation. \n\
*              If the time taken is greater than that of the maximum limit,\n\
*              the orbit in consideration is skipped.\n\
\n\
  double description time limit = %lu\n\
\n\
\n\
\n\
* Parameter: orbit queue size\n\
* Description: size of the orbit heap that is used as a priority queue to\n\
*              establish the order in which the orbits will be processed.\n\
*              Its value should be a positive integer of (aproximately)\n\
*              the number of orbits contained in the metric polytope to\n\
*              compute.\n\
\n\
   orbit queue size = %lu\n\
\n\
\n\
\n\
* Parameter: initial orbit set\n\
* Description: orbit set used to start the orbitwise enumeration. Each initial\n\
*              orbit must beging with 'P', 'C' or 'N' indicating whether it is\n\
*              'precomputed', 'computed' or 'not computed' respectively. Next,\n\
*              the orbit canonical representative should be written followed\n\
*              by '|' and its denominator.\n\
\n\
initial orbit set\n"

/* Function prototypes. */
FILE* next_iteration_input_generator_initialize(void);
void next_iteration_input_generator_finalize(void);
